<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateRepLoginInput StructType
 * @subpackage Structs
 */
class CreateRepLoginInput extends AbstractStructBase
{
    /**
     * The RepDealerBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RepDealerBranchId;
    /**
     * The IsManagedLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsManagedLogin;
    /**
     * The DesiredLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesiredLoginName;
    /**
     * The RepAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressWithName
     */
    public $RepAddress;
    /**
     * The RepPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepPhoneNumber;
    /**
     * The RepEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepEmail;
    /**
     * The RepRoleList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $RepRoleList;
    /**
     * The RepDepartments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerRepDepartmentEnum
     */
    public $RepDepartments;
    /**
     * The RepMarketingPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum
     */
    public $RepMarketingPreferences;
    /**
     * The DesiredPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DesiredPassword;
    /**
     * The IpMaskForLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpMaskForLogin;
    /**
     * The EmployeeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmployeeId;
    /**
     * The SystemSyncId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemSyncId;
    /**
     * Constructor method for CreateRepLoginInput
     * @uses CreateRepLoginInput::setRepDealerBranchId()
     * @uses CreateRepLoginInput::setIsManagedLogin()
     * @uses CreateRepLoginInput::setDesiredLoginName()
     * @uses CreateRepLoginInput::setRepAddress()
     * @uses CreateRepLoginInput::setRepPhoneNumber()
     * @uses CreateRepLoginInput::setRepEmail()
     * @uses CreateRepLoginInput::setRepRoleList()
     * @uses CreateRepLoginInput::setRepDepartments()
     * @uses CreateRepLoginInput::setRepMarketingPreferences()
     * @uses CreateRepLoginInput::setDesiredPassword()
     * @uses CreateRepLoginInput::setIpMaskForLogin()
     * @uses CreateRepLoginInput::setEmployeeId()
     * @uses CreateRepLoginInput::setSystemSyncId()
     * @param int $repDealerBranchId
     * @param bool $isManagedLogin
     * @param string $desiredLoginName
     * @param \StructType\AddressWithName $repAddress
     * @param string $repPhoneNumber
     * @param string $repEmail
     * @param \ArrayType\ArrayOfInt $repRoleList
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences
     * @param string $desiredPassword
     * @param string $ipMaskForLogin
     * @param string $employeeId
     * @param string $systemSyncId
     */
    public function __construct($repDealerBranchId = null, $isManagedLogin = null, $desiredLoginName = null, \StructType\AddressWithName $repAddress = null, $repPhoneNumber = null, $repEmail = null, \ArrayType\ArrayOfInt $repRoleList = null, \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments = null, \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences = null, $desiredPassword = null, $ipMaskForLogin = null, $employeeId = null, $systemSyncId = null)
    {
        $this
            ->setRepDealerBranchId($repDealerBranchId)
            ->setIsManagedLogin($isManagedLogin)
            ->setDesiredLoginName($desiredLoginName)
            ->setRepAddress($repAddress)
            ->setRepPhoneNumber($repPhoneNumber)
            ->setRepEmail($repEmail)
            ->setRepRoleList($repRoleList)
            ->setRepDepartments($repDepartments)
            ->setRepMarketingPreferences($repMarketingPreferences)
            ->setDesiredPassword($desiredPassword)
            ->setIpMaskForLogin($ipMaskForLogin)
            ->setEmployeeId($employeeId)
            ->setSystemSyncId($systemSyncId);
    }
    /**
     * Get RepDealerBranchId value
     * @return int
     */
    public function getRepDealerBranchId()
    {
        return $this->RepDealerBranchId;
    }
    /**
     * Set RepDealerBranchId value
     * @param int $repDealerBranchId
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepDealerBranchId($repDealerBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($repDealerBranchId) && !(is_int($repDealerBranchId) || ctype_digit($repDealerBranchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repDealerBranchId, true), gettype($repDealerBranchId)), __LINE__);
        }
        $this->RepDealerBranchId = $repDealerBranchId;
        return $this;
    }
    /**
     * Get IsManagedLogin value
     * @return bool
     */
    public function getIsManagedLogin()
    {
        return $this->IsManagedLogin;
    }
    /**
     * Set IsManagedLogin value
     * @param bool $isManagedLogin
     * @return \StructType\CreateRepLoginInput
     */
    public function setIsManagedLogin($isManagedLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManagedLogin) && !is_bool($isManagedLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isManagedLogin, true), gettype($isManagedLogin)), __LINE__);
        }
        $this->IsManagedLogin = $isManagedLogin;
        return $this;
    }
    /**
     * Get DesiredLoginName value
     * @return string|null
     */
    public function getDesiredLoginName()
    {
        return $this->DesiredLoginName;
    }
    /**
     * Set DesiredLoginName value
     * @param string $desiredLoginName
     * @return \StructType\CreateRepLoginInput
     */
    public function setDesiredLoginName($desiredLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($desiredLoginName) && !is_string($desiredLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiredLoginName, true), gettype($desiredLoginName)), __LINE__);
        }
        $this->DesiredLoginName = $desiredLoginName;
        return $this;
    }
    /**
     * Get RepAddress value
     * @return \StructType\AddressWithName|null
     */
    public function getRepAddress()
    {
        return $this->RepAddress;
    }
    /**
     * Set RepAddress value
     * @param \StructType\AddressWithName $repAddress
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepAddress(\StructType\AddressWithName $repAddress = null)
    {
        $this->RepAddress = $repAddress;
        return $this;
    }
    /**
     * Get RepPhoneNumber value
     * @return string|null
     */
    public function getRepPhoneNumber()
    {
        return $this->RepPhoneNumber;
    }
    /**
     * Set RepPhoneNumber value
     * @param string $repPhoneNumber
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepPhoneNumber($repPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($repPhoneNumber) && !is_string($repPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repPhoneNumber, true), gettype($repPhoneNumber)), __LINE__);
        }
        $this->RepPhoneNumber = $repPhoneNumber;
        return $this;
    }
    /**
     * Get RepEmail value
     * @return string|null
     */
    public function getRepEmail()
    {
        return $this->RepEmail;
    }
    /**
     * Set RepEmail value
     * @param string $repEmail
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepEmail($repEmail = null)
    {
        // validation for constraint: string
        if (!is_null($repEmail) && !is_string($repEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repEmail, true), gettype($repEmail)), __LINE__);
        }
        $this->RepEmail = $repEmail;
        return $this;
    }
    /**
     * Get RepRoleList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getRepRoleList()
    {
        return $this->RepRoleList;
    }
    /**
     * Set RepRoleList value
     * @param \ArrayType\ArrayOfInt $repRoleList
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepRoleList(\ArrayType\ArrayOfInt $repRoleList = null)
    {
        $this->RepRoleList = $repRoleList;
        return $this;
    }
    /**
     * Get RepDepartments value
     * @return \ArrayType\ArrayOfCustomerRepDepartmentEnum|null
     */
    public function getRepDepartments()
    {
        return $this->RepDepartments;
    }
    /**
     * Set RepDepartments value
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepDepartments(\ArrayType\ArrayOfCustomerRepDepartmentEnum $repDepartments = null)
    {
        $this->RepDepartments = $repDepartments;
        return $this;
    }
    /**
     * Get RepMarketingPreferences value
     * @return \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum|null
     */
    public function getRepMarketingPreferences()
    {
        return $this->RepMarketingPreferences;
    }
    /**
     * Set RepMarketingPreferences value
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences
     * @return \StructType\CreateRepLoginInput
     */
    public function setRepMarketingPreferences(\ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $repMarketingPreferences = null)
    {
        $this->RepMarketingPreferences = $repMarketingPreferences;
        return $this;
    }
    /**
     * Get DesiredPassword value
     * @return string|null
     */
    public function getDesiredPassword()
    {
        return $this->DesiredPassword;
    }
    /**
     * Set DesiredPassword value
     * @param string $desiredPassword
     * @return \StructType\CreateRepLoginInput
     */
    public function setDesiredPassword($desiredPassword = null)
    {
        // validation for constraint: string
        if (!is_null($desiredPassword) && !is_string($desiredPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desiredPassword, true), gettype($desiredPassword)), __LINE__);
        }
        $this->DesiredPassword = $desiredPassword;
        return $this;
    }
    /**
     * Get IpMaskForLogin value
     * @return string|null
     */
    public function getIpMaskForLogin()
    {
        return $this->IpMaskForLogin;
    }
    /**
     * Set IpMaskForLogin value
     * @param string $ipMaskForLogin
     * @return \StructType\CreateRepLoginInput
     */
    public function setIpMaskForLogin($ipMaskForLogin = null)
    {
        // validation for constraint: string
        if (!is_null($ipMaskForLogin) && !is_string($ipMaskForLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipMaskForLogin, true), gettype($ipMaskForLogin)), __LINE__);
        }
        $this->IpMaskForLogin = $ipMaskForLogin;
        return $this;
    }
    /**
     * Get EmployeeId value
     * @return string|null
     */
    public function getEmployeeId()
    {
        return $this->EmployeeId;
    }
    /**
     * Set EmployeeId value
     * @param string $employeeId
     * @return \StructType\CreateRepLoginInput
     */
    public function setEmployeeId($employeeId = null)
    {
        // validation for constraint: string
        if (!is_null($employeeId) && !is_string($employeeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeId, true), gettype($employeeId)), __LINE__);
        }
        $this->EmployeeId = $employeeId;
        return $this;
    }
    /**
     * Get SystemSyncId value
     * @return string|null
     */
    public function getSystemSyncId()
    {
        return $this->SystemSyncId;
    }
    /**
     * Set SystemSyncId value
     * @param string $systemSyncId
     * @return \StructType\CreateRepLoginInput
     */
    public function setSystemSyncId($systemSyncId = null)
    {
        // validation for constraint: string
        if (!is_null($systemSyncId) && !is_string($systemSyncId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemSyncId, true), gettype($systemSyncId)), __LINE__);
        }
        $this->SystemSyncId = $systemSyncId;
        return $this;
    }
}
