<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BuilderProgramInfo StructType
 * @subpackage Structs
 */
class BuilderProgramInfo extends AbstractStructBase
{
    /**
     * The ProgramId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProgramId;
    /**
     * The ProgramName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * Constructor method for BuilderProgramInfo
     * @uses BuilderProgramInfo::setProgramId()
     * @uses BuilderProgramInfo::setProgramName()
     * @param int $programId
     * @param string $programName
     */
    public function __construct($programId = null, $programName = null)
    {
        $this
            ->setProgramId($programId)
            ->setProgramName($programName);
    }
    /**
     * Get ProgramId value
     * @return int
     */
    public function getProgramId()
    {
        return $this->ProgramId;
    }
    /**
     * Set ProgramId value
     * @param int $programId
     * @return \StructType\BuilderProgramInfo
     */
    public function setProgramId($programId = null)
    {
        // validation for constraint: int
        if (!is_null($programId) && !(is_int($programId) || ctype_digit($programId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($programId, true), gettype($programId)), __LINE__);
        }
        $this->ProgramId = $programId;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \StructType\BuilderProgramInfo
     */
    public function setProgramName($programName = null)
    {
        // validation for constraint: string
        if (!is_null($programName) && !is_string($programName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programName, true), gettype($programName)), __LINE__);
        }
        $this->ProgramName = $programName;
        return $this;
    }
}
