<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssignTrainingPathToRepInput StructType
 * @subpackage Structs
 */
class AssignTrainingPathToRepInput extends AbstractStructBase
{
    /**
     * The TrainingPathId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TrainingPathId;
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RepId;
    /**
     * The SupportId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SupportId;
    /**
     * Constructor method for AssignTrainingPathToRepInput
     * @uses AssignTrainingPathToRepInput::setTrainingPathId()
     * @uses AssignTrainingPathToRepInput::setRepId()
     * @uses AssignTrainingPathToRepInput::setSupportId()
     * @param int $trainingPathId
     * @param int $repId
     * @param int $supportId
     */
    public function __construct($trainingPathId = null, $repId = null, $supportId = null)
    {
        $this
            ->setTrainingPathId($trainingPathId)
            ->setRepId($repId)
            ->setSupportId($supportId);
    }
    /**
     * Get TrainingPathId value
     * @return int
     */
    public function getTrainingPathId()
    {
        return $this->TrainingPathId;
    }
    /**
     * Set TrainingPathId value
     * @param int $trainingPathId
     * @return \StructType\AssignTrainingPathToRepInput
     */
    public function setTrainingPathId($trainingPathId = null)
    {
        // validation for constraint: int
        if (!is_null($trainingPathId) && !(is_int($trainingPathId) || ctype_digit($trainingPathId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trainingPathId, true), gettype($trainingPathId)), __LINE__);
        }
        $this->TrainingPathId = $trainingPathId;
        return $this;
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\AssignTrainingPathToRepInput
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get SupportId value
     * @return int
     */
    public function getSupportId()
    {
        return $this->SupportId;
    }
    /**
     * Set SupportId value
     * @param int $supportId
     * @return \StructType\AssignTrainingPathToRepInput
     */
    public function setSupportId($supportId = null)
    {
        // validation for constraint: int
        if (!is_null($supportId) && !(is_int($supportId) || ctype_digit($supportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supportId, true), gettype($supportId)), __LINE__);
        }
        $this->SupportId = $supportId;
        return $this;
    }
}
