<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named GetWizardWebResponse
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get the URL of a specific wizard to redirect to.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWizardWebResponse $parameters
     * @return \StructType\GetWizardWebResponseResponse|bool
     */
    public function GetWizardWebResponse(\StructType\GetWizardWebResponse $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWizardWebResponse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRepList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRepList $parameters
     * @return \StructType\GetRepListResponse|bool
     */
    public function GetRepList(\StructType\GetRepList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRepList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRepListForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRepListForDealer $parameters
     * @return \StructType\GetRepListForDealerResponse|bool
     */
    public function GetRepListForDealer(\StructType\GetRepListForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRepListForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPanelTemplateIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPanelTemplateIds $parameters
     * @return \StructType\GetPanelTemplateIdsResponse|bool
     */
    public function GetPanelTemplateIds(\StructType\GetPanelTemplateIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPanelTemplateIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPackageIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPackageIds $parameters
     * @return \StructType\GetPackageIdsResponse|bool
     */
    public function GetPackageIds(\StructType\GetPackageIds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPackageIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomPackageTemplates
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomPackageTemplates $parameters
     * @return \StructType\GetCustomPackageTemplatesResponse|bool
     */
    public function GetCustomPackageTemplates(\StructType\GetCustomPackageTemplates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomPackageTemplates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomPackageTemplatesV2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get custom package templates with caller version and branch ID (optional).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomPackageTemplatesV2 $parameters
     * @return \StructType\GetCustomPackageTemplatesV2Response|bool
     */
    public function GetCustomPackageTemplatesV2(\StructType\GetCustomPackageTemplatesV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomPackageTemplatesV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRepRoles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get list of roles available to reps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRepRoles $parameters
     * @return \StructType\GetRepRolesResponse|bool
     */
    public function GetRepRoles(\StructType\GetRepRoles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRepRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentRepInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get information about a rep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrentRepInfo $parameters
     * @return \StructType\GetCurrentRepInfoResponse|bool
     */
    public function GetCurrentRepInfo(\StructType\GetCurrentRepInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrentRepInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDealerId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get rep's dealer information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDealerId $parameters
     * @return \StructType\GetDealerIdResponse|bool
     */
    public function GetDealerId(\StructType\GetDealerId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDealerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBranch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get information about a branch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBranch $parameters
     * @return \StructType\GetBranchResponse|bool
     */
    public function GetBranch(\StructType\GetBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBranches
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBranches $parameters
     * @return \StructType\GetBranchesResponse|bool
     */
    public function GetBranches(\StructType\GetBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupportedPanelTypes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Returns the list of panel types currently supported by a dealer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupportedPanelTypes $parameters
     * @return \StructType\GetSupportedPanelTypesResponse|bool
     */
    public function GetSupportedPanelTypes(\StructType\GetSupportedPanelTypes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSupportedPanelTypes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPanelVersionMappings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPanelVersionMappings $parameters
     * @return \StructType\GetPanelVersionMappingsResponse|bool
     */
    public function GetPanelVersionMappings(\StructType\GetPanelVersionMappings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPanelVersionMappings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRepIdByEmployeeId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Lookup an ADC rep by their employee identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRepIdByEmployeeId $parameters
     * @return \StructType\GetRepIdByEmployeeIdResponse|bool
     */
    public function GetRepIdByEmployeeId(\StructType\GetRepIdByEmployeeId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRepIdByEmployeeId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerUnsubscribes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retrieve all customers that have unsubscribed from at least one type of Alarm.com email.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerUnsubscribes $parameters
     * @return \StructType\GetCustomerUnsubscribesResponse|bool
     */
    public function GetCustomerUnsubscribes(\StructType\GetCustomerUnsubscribes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerUnsubscribes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerUnsubscribesForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Retrieve all customers that have unsubscribed from at least one type of Alarm.com email.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerUnsubscribesForDealer $parameters
     * @return \StructType\GetCustomerUnsubscribesForDealerResponse|bool
     */
    public function GetCustomerUnsubscribesForDealer(\StructType\GetCustomerUnsubscribesForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomerUnsubscribesForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBuilderPrograms
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all builder programs associated with the loggedInRep's parent dealer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBuilderPrograms $parameters
     * @return \StructType\GetBuilderProgramsResponse|bool
     */
    public function GetBuilderPrograms(\StructType\GetBuilderPrograms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBuilderPrograms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBinderContents
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get My Binder Resources for Rep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBinderContents $parameters
     * @return \StructType\GetBinderContentsResponse|bool
     */
    public function GetBinderContents(\StructType\GetBinderContents $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBinderContents($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupportTickets
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupportTickets $parameters
     * @return \StructType\GetSupportTicketsResponse|bool
     */
    public function GetSupportTickets(\StructType\GetSupportTickets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSupportTickets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupportTicketCategories
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupportTicketCategories $parameters
     * @return \StructType\GetSupportTicketCategoriesResponse|bool
     */
    public function GetSupportTicketCategories(\StructType\GetSupportTicketCategories $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSupportTicketCategories($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSupportTicketComments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSupportTicketComments $parameters
     * @return \StructType\GetSupportTicketCommentsResponse|bool
     */
    public function GetSupportTicketComments(\StructType\GetSupportTicketComments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSupportTicketComments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCSPhoneNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCSPhoneNumber $parameters
     * @return \StructType\GetCSPhoneNumberResponse|bool
     */
    public function GetCSPhoneNumber(\StructType\GetCSPhoneNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCSPhoneNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * GetExtendedDealerFileUploadsForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get all file uploads for a dealer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExtendedDealerFileUploadsForDealer $parameters
     * @return \StructType\GetExtendedDealerFileUploadsForDealerResponse|bool
     */
    public function GetExtendedDealerFileUploadsForDealer(\StructType\GetExtendedDealerFileUploadsForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExtendedDealerFileUploadsForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExtendedDealerFileUpload
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Get a file upload.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExtendedDealerFileUpload $parameters
     * @return \StructType\GetExtendedDealerFileUploadResponse|bool
     */
    public function GetExtendedDealerFileUpload(\StructType\GetExtendedDealerFileUpload $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExtendedDealerFileUpload($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExtendedDealerErrorFile
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Download an extended dealer data error file.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExtendedDealerErrorFile $parameters
     * @return \StructType\GetExtendedDealerErrorFileResponse|bool
     */
    public function GetExtendedDealerErrorFile(\StructType\GetExtendedDealerErrorFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetExtendedDealerErrorFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBinderContentsResponse|\StructType\GetBranchesResponse|\StructType\GetBranchResponse|\StructType\GetBuilderProgramsResponse|\StructType\GetCSPhoneNumberResponse|\StructType\GetCurrentRepInfoResponse|\StructType\GetCustomerUnsubscribesForDealerResponse|\StructType\GetCustomerUnsubscribesResponse|\StructType\GetCustomPackageTemplatesResponse|\StructType\GetCustomPackageTemplatesV2Response|\StructType\GetDealerIdResponse|\StructType\GetExtendedDealerErrorFileResponse|\StructType\GetExtendedDealerFileUploadResponse|\StructType\GetExtendedDealerFileUploadsForDealerResponse|\StructType\GetPackageIdsResponse|\StructType\GetPanelTemplateIdsResponse|\StructType\GetPanelVersionMappingsResponse|\StructType\GetRepIdByEmployeeIdResponse|\StructType\GetRepListForDealerResponse|\StructType\GetRepListResponse|\StructType\GetRepRolesResponse|\StructType\GetSupportedPanelTypesResponse|\StructType\GetSupportTicketCategoriesResponse|\StructType\GetSupportTicketCommentsResponse|\StructType\GetSupportTicketsResponse|\StructType\GetWizardWebResponseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
