<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for IssuePriorityEnum EnumType
 * @subpackage Enumerations
 */
class IssuePriorityEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Emergency'
     * @return string 'Emergency'
     */
    const VALUE_EMERGENCY = 'Emergency';
    /**
     * Constant for value 'High'
     * @return string 'High'
     */
    const VALUE_HIGH = 'High';
    /**
     * Constant for value 'Medium'
     * @return string 'Medium'
     */
    const VALUE_MEDIUM = 'Medium';
    /**
     * Constant for value 'Low'
     * @return string 'Low'
     */
    const VALUE_LOW = 'Low';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_EMERGENCY
     * @uses self::VALUE_HIGH
     * @uses self::VALUE_MEDIUM
     * @uses self::VALUE_LOW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_EMERGENCY,
            self::VALUE_HIGH,
            self::VALUE_MEDIUM,
            self::VALUE_LOW,
        );
    }
}
