<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPanelVersion ArrayType
 * @subpackage Arrays
 */
class ArrayOfPanelVersion extends AbstractStructArrayBase
{
    /**
     * The PanelVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PanelVersion[]
     */
    public $PanelVersion;
    /**
     * Constructor method for ArrayOfPanelVersion
     * @uses ArrayOfPanelVersion::setPanelVersion()
     * @param \StructType\PanelVersion[] $panelVersion
     */
    public function __construct(array $panelVersion = array())
    {
        $this
            ->setPanelVersion($panelVersion);
    }
    /**
     * Get PanelVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PanelVersion[]|null
     */
    public function getPanelVersion()
    {
        return isset($this->PanelVersion) ? $this->PanelVersion : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPanelVersion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPanelVersion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePanelVersionForArrayConstraintsFromSetPanelVersion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPanelVersionPanelVersionItem) {
            // validation for constraint: itemType
            if (!$arrayOfPanelVersionPanelVersionItem instanceof \StructType\PanelVersion) {
                $invalidValues[] = is_object($arrayOfPanelVersionPanelVersionItem) ? get_class($arrayOfPanelVersionPanelVersionItem) : sprintf('%s(%s)', gettype($arrayOfPanelVersionPanelVersionItem), var_export($arrayOfPanelVersionPanelVersionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PanelVersion property can only contain items of type \StructType\PanelVersion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PanelVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PanelVersion[] $panelVersion
     * @return \ArrayType\ArrayOfPanelVersion
     */
    public function setPanelVersion(array $panelVersion = array())
    {
        // validation for constraint: array
        if ('' !== ($panelVersionArrayErrorMessage = self::validatePanelVersionForArrayConstraintsFromSetPanelVersion($panelVersion))) {
            throw new \InvalidArgumentException($panelVersionArrayErrorMessage, __LINE__);
        }
        if (is_null($panelVersion) || (is_array($panelVersion) && empty($panelVersion))) {
            unset($this->PanelVersion);
        } else {
            $this->PanelVersion = $panelVersion;
        }
        return $this;
    }
    /**
     * Add item to PanelVersion value
     * @throws \InvalidArgumentException
     * @param \StructType\PanelVersion $item
     * @return \ArrayType\ArrayOfPanelVersion
     */
    public function addToPanelVersion(\StructType\PanelVersion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PanelVersion) {
            throw new \InvalidArgumentException(sprintf('The PanelVersion property can only contain items of type \StructType\PanelVersion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PanelVersion[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PanelVersion|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PanelVersion|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PanelVersion|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PanelVersion|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PanelVersion|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PanelVersion
     */
    public function getAttributeName()
    {
        return 'PanelVersion';
    }
}
