<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBranchInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfBranchInfo extends AbstractStructArrayBase
{
    /**
     * The BranchInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BranchInfo[]
     */
    public $BranchInfo;
    /**
     * Constructor method for ArrayOfBranchInfo
     * @uses ArrayOfBranchInfo::setBranchInfo()
     * @param \StructType\BranchInfo[] $branchInfo
     */
    public function __construct(array $branchInfo = array())
    {
        $this
            ->setBranchInfo($branchInfo);
    }
    /**
     * Get BranchInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BranchInfo[]|null
     */
    public function getBranchInfo()
    {
        return isset($this->BranchInfo) ? $this->BranchInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBranchInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranchInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchInfoForArrayConstraintsFromSetBranchInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBranchInfoBranchInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfBranchInfoBranchInfoItem instanceof \StructType\BranchInfo) {
                $invalidValues[] = is_object($arrayOfBranchInfoBranchInfoItem) ? get_class($arrayOfBranchInfoBranchInfoItem) : sprintf('%s(%s)', gettype($arrayOfBranchInfoBranchInfoItem), var_export($arrayOfBranchInfoBranchInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BranchInfo property can only contain items of type \StructType\BranchInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BranchInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BranchInfo[] $branchInfo
     * @return \ArrayType\ArrayOfBranchInfo
     */
    public function setBranchInfo(array $branchInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($branchInfoArrayErrorMessage = self::validateBranchInfoForArrayConstraintsFromSetBranchInfo($branchInfo))) {
            throw new \InvalidArgumentException($branchInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($branchInfo) || (is_array($branchInfo) && empty($branchInfo))) {
            unset($this->BranchInfo);
        } else {
            $this->BranchInfo = $branchInfo;
        }
        return $this;
    }
    /**
     * Add item to BranchInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\BranchInfo $item
     * @return \ArrayType\ArrayOfBranchInfo
     */
    public function addToBranchInfo(\StructType\BranchInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BranchInfo) {
            throw new \InvalidArgumentException(sprintf('The BranchInfo property can only contain items of type \StructType\BranchInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BranchInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BranchInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BranchInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BranchInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BranchInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BranchInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BranchInfo
     */
    public function getAttributeName()
    {
        return 'BranchInfo';
    }
}
