<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WsCSPhone StructType
 * @subpackage Structs
 */
class WsCSPhone extends AbstractStructBase
{
    /**
     * The CSPhoneID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CSPhoneID;
    /**
     * The CSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CSID;
    /**
     * The UsePhoneAsBackup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UsePhoneAsBackup;
    /**
     * The CSPhoneKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSPhoneKey;
    /**
     * The PhoneDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneDesc;
    /**
     * The CSName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSName;
    /**
     * The LinecardNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LinecardNumber;
    /**
     * The ForwardMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ForwardMethod;
    /**
     * The Protocol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Protocol;
    /**
     * The Prefix
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prefix;
    /**
     * The FibroEndpoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FibroEndpoint;
    /**
     * Constructor method for WsCSPhone
     * @uses WsCSPhone::setCSPhoneID()
     * @uses WsCSPhone::setCSID()
     * @uses WsCSPhone::setUsePhoneAsBackup()
     * @uses WsCSPhone::setCSPhoneKey()
     * @uses WsCSPhone::setPhoneDesc()
     * @uses WsCSPhone::setCSName()
     * @uses WsCSPhone::setLinecardNumber()
     * @uses WsCSPhone::setForwardMethod()
     * @uses WsCSPhone::setProtocol()
     * @uses WsCSPhone::setPrefix()
     * @uses WsCSPhone::setFibroEndpoint()
     * @param int $cSPhoneID
     * @param int $cSID
     * @param bool $usePhoneAsBackup
     * @param string $cSPhoneKey
     * @param string $phoneDesc
     * @param string $cSName
     * @param string $linecardNumber
     * @param string $forwardMethod
     * @param string $protocol
     * @param string $prefix
     * @param string $fibroEndpoint
     */
    public function __construct($cSPhoneID = null, $cSID = null, $usePhoneAsBackup = null, $cSPhoneKey = null, $phoneDesc = null, $cSName = null, $linecardNumber = null, $forwardMethod = null, $protocol = null, $prefix = null, $fibroEndpoint = null)
    {
        $this
            ->setCSPhoneID($cSPhoneID)
            ->setCSID($cSID)
            ->setUsePhoneAsBackup($usePhoneAsBackup)
            ->setCSPhoneKey($cSPhoneKey)
            ->setPhoneDesc($phoneDesc)
            ->setCSName($cSName)
            ->setLinecardNumber($linecardNumber)
            ->setForwardMethod($forwardMethod)
            ->setProtocol($protocol)
            ->setPrefix($prefix)
            ->setFibroEndpoint($fibroEndpoint);
    }
    /**
     * Get CSPhoneID value
     * @return int
     */
    public function getCSPhoneID()
    {
        return $this->CSPhoneID;
    }
    /**
     * Set CSPhoneID value
     * @param int $cSPhoneID
     * @return \StructType\WsCSPhone
     */
    public function setCSPhoneID($cSPhoneID = null)
    {
        // validation for constraint: int
        if (!is_null($cSPhoneID) && !(is_int($cSPhoneID) || ctype_digit($cSPhoneID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cSPhoneID, true), gettype($cSPhoneID)), __LINE__);
        }
        $this->CSPhoneID = $cSPhoneID;
        return $this;
    }
    /**
     * Get CSID value
     * @return int
     */
    public function getCSID()
    {
        return $this->CSID;
    }
    /**
     * Set CSID value
     * @param int $cSID
     * @return \StructType\WsCSPhone
     */
    public function setCSID($cSID = null)
    {
        // validation for constraint: int
        if (!is_null($cSID) && !(is_int($cSID) || ctype_digit($cSID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cSID, true), gettype($cSID)), __LINE__);
        }
        $this->CSID = $cSID;
        return $this;
    }
    /**
     * Get UsePhoneAsBackup value
     * @return bool
     */
    public function getUsePhoneAsBackup()
    {
        return $this->UsePhoneAsBackup;
    }
    /**
     * Set UsePhoneAsBackup value
     * @param bool $usePhoneAsBackup
     * @return \StructType\WsCSPhone
     */
    public function setUsePhoneAsBackup($usePhoneAsBackup = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePhoneAsBackup) && !is_bool($usePhoneAsBackup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePhoneAsBackup, true), gettype($usePhoneAsBackup)), __LINE__);
        }
        $this->UsePhoneAsBackup = $usePhoneAsBackup;
        return $this;
    }
    /**
     * Get CSPhoneKey value
     * @return string|null
     */
    public function getCSPhoneKey()
    {
        return $this->CSPhoneKey;
    }
    /**
     * Set CSPhoneKey value
     * @param string $cSPhoneKey
     * @return \StructType\WsCSPhone
     */
    public function setCSPhoneKey($cSPhoneKey = null)
    {
        // validation for constraint: string
        if (!is_null($cSPhoneKey) && !is_string($cSPhoneKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSPhoneKey, true), gettype($cSPhoneKey)), __LINE__);
        }
        $this->CSPhoneKey = $cSPhoneKey;
        return $this;
    }
    /**
     * Get PhoneDesc value
     * @return string|null
     */
    public function getPhoneDesc()
    {
        return $this->PhoneDesc;
    }
    /**
     * Set PhoneDesc value
     * @param string $phoneDesc
     * @return \StructType\WsCSPhone
     */
    public function setPhoneDesc($phoneDesc = null)
    {
        // validation for constraint: string
        if (!is_null($phoneDesc) && !is_string($phoneDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneDesc, true), gettype($phoneDesc)), __LINE__);
        }
        $this->PhoneDesc = $phoneDesc;
        return $this;
    }
    /**
     * Get CSName value
     * @return string|null
     */
    public function getCSName()
    {
        return $this->CSName;
    }
    /**
     * Set CSName value
     * @param string $cSName
     * @return \StructType\WsCSPhone
     */
    public function setCSName($cSName = null)
    {
        // validation for constraint: string
        if (!is_null($cSName) && !is_string($cSName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSName, true), gettype($cSName)), __LINE__);
        }
        $this->CSName = $cSName;
        return $this;
    }
    /**
     * Get LinecardNumber value
     * @return string|null
     */
    public function getLinecardNumber()
    {
        return $this->LinecardNumber;
    }
    /**
     * Set LinecardNumber value
     * @param string $linecardNumber
     * @return \StructType\WsCSPhone
     */
    public function setLinecardNumber($linecardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($linecardNumber) && !is_string($linecardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linecardNumber, true), gettype($linecardNumber)), __LINE__);
        }
        $this->LinecardNumber = $linecardNumber;
        return $this;
    }
    /**
     * Get ForwardMethod value
     * @return string|null
     */
    public function getForwardMethod()
    {
        return $this->ForwardMethod;
    }
    /**
     * Set ForwardMethod value
     * @param string $forwardMethod
     * @return \StructType\WsCSPhone
     */
    public function setForwardMethod($forwardMethod = null)
    {
        // validation for constraint: string
        if (!is_null($forwardMethod) && !is_string($forwardMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardMethod, true), gettype($forwardMethod)), __LINE__);
        }
        $this->ForwardMethod = $forwardMethod;
        return $this;
    }
    /**
     * Get Protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->Protocol;
    }
    /**
     * Set Protocol value
     * @param string $protocol
     * @return \StructType\WsCSPhone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocol, true), gettype($protocol)), __LINE__);
        }
        $this->Protocol = $protocol;
        return $this;
    }
    /**
     * Get Prefix value
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->Prefix;
    }
    /**
     * Set Prefix value
     * @param string $prefix
     * @return \StructType\WsCSPhone
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefix, true), gettype($prefix)), __LINE__);
        }
        $this->Prefix = $prefix;
        return $this;
    }
    /**
     * Get FibroEndpoint value
     * @return string|null
     */
    public function getFibroEndpoint()
    {
        return $this->FibroEndpoint;
    }
    /**
     * Set FibroEndpoint value
     * @param string $fibroEndpoint
     * @return \StructType\WsCSPhone
     */
    public function setFibroEndpoint($fibroEndpoint = null)
    {
        // validation for constraint: string
        if (!is_null($fibroEndpoint) && !is_string($fibroEndpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fibroEndpoint, true), gettype($fibroEndpoint)), __LINE__);
        }
        $this->FibroEndpoint = $fibroEndpoint;
        return $this;
    }
}
