<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRepLoginInput StructType
 * @subpackage Structs
 */
class UpdateRepLoginInput extends AbstractStructBase
{
    /**
     * The NewRepDealerBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NewRepDealerBranchId;
    /**
     * The DisableEmailUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DisableEmailUpdate;
    /**
     * The DisableAutomaticLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DisableAutomaticLogin;
    /**
     * The RepLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLogin;
    /**
     * The RepPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepPassword;
    /**
     * The NewRepLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewRepLogin;
    /**
     * The NewRepAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressWithName
     */
    public $NewRepAddress;
    /**
     * The NewRepPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewRepPhoneNumber;
    /**
     * The NewRepEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewRepEmail;
    /**
     * The NewRepRoleList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $NewRepRoleList;
    /**
     * The NewRepDepartments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomerRepDepartmentEnum
     */
    public $NewRepDepartments;
    /**
     * The NewRepMarketingPreferences
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum
     */
    public $NewRepMarketingPreferences;
    /**
     * The NewRepDesiredPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewRepDesiredPassword;
    /**
     * The IpMaskForLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpMaskForLogin;
    /**
     * Constructor method for UpdateRepLoginInput
     * @uses UpdateRepLoginInput::setNewRepDealerBranchId()
     * @uses UpdateRepLoginInput::setDisableEmailUpdate()
     * @uses UpdateRepLoginInput::setDisableAutomaticLogin()
     * @uses UpdateRepLoginInput::setRepLogin()
     * @uses UpdateRepLoginInput::setRepPassword()
     * @uses UpdateRepLoginInput::setNewRepLogin()
     * @uses UpdateRepLoginInput::setNewRepAddress()
     * @uses UpdateRepLoginInput::setNewRepPhoneNumber()
     * @uses UpdateRepLoginInput::setNewRepEmail()
     * @uses UpdateRepLoginInput::setNewRepRoleList()
     * @uses UpdateRepLoginInput::setNewRepDepartments()
     * @uses UpdateRepLoginInput::setNewRepMarketingPreferences()
     * @uses UpdateRepLoginInput::setNewRepDesiredPassword()
     * @uses UpdateRepLoginInput::setIpMaskForLogin()
     * @param int $newRepDealerBranchId
     * @param bool $disableEmailUpdate
     * @param bool $disableAutomaticLogin
     * @param string $repLogin
     * @param string $repPassword
     * @param string $newRepLogin
     * @param \StructType\AddressWithName $newRepAddress
     * @param string $newRepPhoneNumber
     * @param string $newRepEmail
     * @param \ArrayType\ArrayOfInt $newRepRoleList
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $newRepDepartments
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $newRepMarketingPreferences
     * @param string $newRepDesiredPassword
     * @param string $ipMaskForLogin
     */
    public function __construct($newRepDealerBranchId = null, $disableEmailUpdate = null, $disableAutomaticLogin = null, $repLogin = null, $repPassword = null, $newRepLogin = null, \StructType\AddressWithName $newRepAddress = null, $newRepPhoneNumber = null, $newRepEmail = null, \ArrayType\ArrayOfInt $newRepRoleList = null, \ArrayType\ArrayOfCustomerRepDepartmentEnum $newRepDepartments = null, \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $newRepMarketingPreferences = null, $newRepDesiredPassword = null, $ipMaskForLogin = null)
    {
        $this
            ->setNewRepDealerBranchId($newRepDealerBranchId)
            ->setDisableEmailUpdate($disableEmailUpdate)
            ->setDisableAutomaticLogin($disableAutomaticLogin)
            ->setRepLogin($repLogin)
            ->setRepPassword($repPassword)
            ->setNewRepLogin($newRepLogin)
            ->setNewRepAddress($newRepAddress)
            ->setNewRepPhoneNumber($newRepPhoneNumber)
            ->setNewRepEmail($newRepEmail)
            ->setNewRepRoleList($newRepRoleList)
            ->setNewRepDepartments($newRepDepartments)
            ->setNewRepMarketingPreferences($newRepMarketingPreferences)
            ->setNewRepDesiredPassword($newRepDesiredPassword)
            ->setIpMaskForLogin($ipMaskForLogin);
    }
    /**
     * Get NewRepDealerBranchId value
     * @return int
     */
    public function getNewRepDealerBranchId()
    {
        return $this->NewRepDealerBranchId;
    }
    /**
     * Set NewRepDealerBranchId value
     * @param int $newRepDealerBranchId
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepDealerBranchId($newRepDealerBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($newRepDealerBranchId) && !(is_int($newRepDealerBranchId) || ctype_digit($newRepDealerBranchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newRepDealerBranchId, true), gettype($newRepDealerBranchId)), __LINE__);
        }
        $this->NewRepDealerBranchId = $newRepDealerBranchId;
        return $this;
    }
    /**
     * Get DisableEmailUpdate value
     * @return bool
     */
    public function getDisableEmailUpdate()
    {
        return $this->DisableEmailUpdate;
    }
    /**
     * Set DisableEmailUpdate value
     * @param bool $disableEmailUpdate
     * @return \StructType\UpdateRepLoginInput
     */
    public function setDisableEmailUpdate($disableEmailUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableEmailUpdate) && !is_bool($disableEmailUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disableEmailUpdate, true), gettype($disableEmailUpdate)), __LINE__);
        }
        $this->DisableEmailUpdate = $disableEmailUpdate;
        return $this;
    }
    /**
     * Get DisableAutomaticLogin value
     * @return bool
     */
    public function getDisableAutomaticLogin()
    {
        return $this->DisableAutomaticLogin;
    }
    /**
     * Set DisableAutomaticLogin value
     * @param bool $disableAutomaticLogin
     * @return \StructType\UpdateRepLoginInput
     */
    public function setDisableAutomaticLogin($disableAutomaticLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableAutomaticLogin) && !is_bool($disableAutomaticLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disableAutomaticLogin, true), gettype($disableAutomaticLogin)), __LINE__);
        }
        $this->DisableAutomaticLogin = $disableAutomaticLogin;
        return $this;
    }
    /**
     * Get RepLogin value
     * @return string|null
     */
    public function getRepLogin()
    {
        return $this->RepLogin;
    }
    /**
     * Set RepLogin value
     * @param string $repLogin
     * @return \StructType\UpdateRepLoginInput
     */
    public function setRepLogin($repLogin = null)
    {
        // validation for constraint: string
        if (!is_null($repLogin) && !is_string($repLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repLogin, true), gettype($repLogin)), __LINE__);
        }
        $this->RepLogin = $repLogin;
        return $this;
    }
    /**
     * Get RepPassword value
     * @return string|null
     */
    public function getRepPassword()
    {
        return $this->RepPassword;
    }
    /**
     * Set RepPassword value
     * @param string $repPassword
     * @return \StructType\UpdateRepLoginInput
     */
    public function setRepPassword($repPassword = null)
    {
        // validation for constraint: string
        if (!is_null($repPassword) && !is_string($repPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repPassword, true), gettype($repPassword)), __LINE__);
        }
        $this->RepPassword = $repPassword;
        return $this;
    }
    /**
     * Get NewRepLogin value
     * @return string|null
     */
    public function getNewRepLogin()
    {
        return $this->NewRepLogin;
    }
    /**
     * Set NewRepLogin value
     * @param string $newRepLogin
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepLogin($newRepLogin = null)
    {
        // validation for constraint: string
        if (!is_null($newRepLogin) && !is_string($newRepLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRepLogin, true), gettype($newRepLogin)), __LINE__);
        }
        $this->NewRepLogin = $newRepLogin;
        return $this;
    }
    /**
     * Get NewRepAddress value
     * @return \StructType\AddressWithName|null
     */
    public function getNewRepAddress()
    {
        return $this->NewRepAddress;
    }
    /**
     * Set NewRepAddress value
     * @param \StructType\AddressWithName $newRepAddress
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepAddress(\StructType\AddressWithName $newRepAddress = null)
    {
        $this->NewRepAddress = $newRepAddress;
        return $this;
    }
    /**
     * Get NewRepPhoneNumber value
     * @return string|null
     */
    public function getNewRepPhoneNumber()
    {
        return $this->NewRepPhoneNumber;
    }
    /**
     * Set NewRepPhoneNumber value
     * @param string $newRepPhoneNumber
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepPhoneNumber($newRepPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($newRepPhoneNumber) && !is_string($newRepPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRepPhoneNumber, true), gettype($newRepPhoneNumber)), __LINE__);
        }
        $this->NewRepPhoneNumber = $newRepPhoneNumber;
        return $this;
    }
    /**
     * Get NewRepEmail value
     * @return string|null
     */
    public function getNewRepEmail()
    {
        return $this->NewRepEmail;
    }
    /**
     * Set NewRepEmail value
     * @param string $newRepEmail
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepEmail($newRepEmail = null)
    {
        // validation for constraint: string
        if (!is_null($newRepEmail) && !is_string($newRepEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRepEmail, true), gettype($newRepEmail)), __LINE__);
        }
        $this->NewRepEmail = $newRepEmail;
        return $this;
    }
    /**
     * Get NewRepRoleList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getNewRepRoleList()
    {
        return $this->NewRepRoleList;
    }
    /**
     * Set NewRepRoleList value
     * @param \ArrayType\ArrayOfInt $newRepRoleList
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepRoleList(\ArrayType\ArrayOfInt $newRepRoleList = null)
    {
        $this->NewRepRoleList = $newRepRoleList;
        return $this;
    }
    /**
     * Get NewRepDepartments value
     * @return \ArrayType\ArrayOfCustomerRepDepartmentEnum|null
     */
    public function getNewRepDepartments()
    {
        return $this->NewRepDepartments;
    }
    /**
     * Set NewRepDepartments value
     * @param \ArrayType\ArrayOfCustomerRepDepartmentEnum $newRepDepartments
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepDepartments(\ArrayType\ArrayOfCustomerRepDepartmentEnum $newRepDepartments = null)
    {
        $this->NewRepDepartments = $newRepDepartments;
        return $this;
    }
    /**
     * Get NewRepMarketingPreferences value
     * @return \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum|null
     */
    public function getNewRepMarketingPreferences()
    {
        return $this->NewRepMarketingPreferences;
    }
    /**
     * Set NewRepMarketingPreferences value
     * @param \ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $newRepMarketingPreferences
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepMarketingPreferences(\ArrayType\ArrayOfDealerMarketingEmailPreferenceEnum $newRepMarketingPreferences = null)
    {
        $this->NewRepMarketingPreferences = $newRepMarketingPreferences;
        return $this;
    }
    /**
     * Get NewRepDesiredPassword value
     * @return string|null
     */
    public function getNewRepDesiredPassword()
    {
        return $this->NewRepDesiredPassword;
    }
    /**
     * Set NewRepDesiredPassword value
     * @param string $newRepDesiredPassword
     * @return \StructType\UpdateRepLoginInput
     */
    public function setNewRepDesiredPassword($newRepDesiredPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newRepDesiredPassword) && !is_string($newRepDesiredPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newRepDesiredPassword, true), gettype($newRepDesiredPassword)), __LINE__);
        }
        $this->NewRepDesiredPassword = $newRepDesiredPassword;
        return $this;
    }
    /**
     * Get IpMaskForLogin value
     * @return string|null
     */
    public function getIpMaskForLogin()
    {
        return $this->IpMaskForLogin;
    }
    /**
     * Set IpMaskForLogin value
     * @param string $ipMaskForLogin
     * @return \StructType\UpdateRepLoginInput
     */
    public function setIpMaskForLogin($ipMaskForLogin = null)
    {
        // validation for constraint: string
        if (!is_null($ipMaskForLogin) && !is_string($ipMaskForLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipMaskForLogin, true), gettype($ipMaskForLogin)), __LINE__);
        }
        $this->IpMaskForLogin = $ipMaskForLogin;
        return $this;
    }
}
