<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetIpMaskRestrictionInput StructType
 * @subpackage Structs
 */
class SetIpMaskRestrictionInput extends AbstractStructBase
{
    /**
     * The RepLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLogin;
    /**
     * The IpMask
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpMask;
    /**
     * Constructor method for SetIpMaskRestrictionInput
     * @uses SetIpMaskRestrictionInput::setRepLogin()
     * @uses SetIpMaskRestrictionInput::setIpMask()
     * @param string $repLogin
     * @param string $ipMask
     */
    public function __construct($repLogin = null, $ipMask = null)
    {
        $this
            ->setRepLogin($repLogin)
            ->setIpMask($ipMask);
    }
    /**
     * Get RepLogin value
     * @return string|null
     */
    public function getRepLogin()
    {
        return $this->RepLogin;
    }
    /**
     * Set RepLogin value
     * @param string $repLogin
     * @return \StructType\SetIpMaskRestrictionInput
     */
    public function setRepLogin($repLogin = null)
    {
        // validation for constraint: string
        if (!is_null($repLogin) && !is_string($repLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repLogin, true), gettype($repLogin)), __LINE__);
        }
        $this->RepLogin = $repLogin;
        return $this;
    }
    /**
     * Get IpMask value
     * @return string|null
     */
    public function getIpMask()
    {
        return $this->IpMask;
    }
    /**
     * Set IpMask value
     * @param string $ipMask
     * @return \StructType\SetIpMaskRestrictionInput
     */
    public function setIpMask($ipMask = null)
    {
        // validation for constraint: string
        if (!is_null($ipMask) && !is_string($ipMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ipMask, true), gettype($ipMask)), __LINE__);
        }
        $this->IpMask = $ipMask;
        return $this;
    }
}
