<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rep StructType
 * @subpackage Structs
 */
class Rep extends AbstractStructBase
{
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepId;
    /**
     * The RepDealerBranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RepDealerBranchId;
    /**
     * The SupportId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SupportId;
    /**
     * The LastLoginDatetime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastLoginDatetime;
    /**
     * The RepLoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLoginName;
    /**
     * The RepAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressWithName
     */
    public $RepAddress;
    /**
     * The RepPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepPhoneNumber;
    /**
     * The RepEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepEmail;
    /**
     * The RepRoleList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRepRole
     */
    public $RepRoleList;
    /**
     * Constructor method for Rep
     * @uses Rep::setRepId()
     * @uses Rep::setRepDealerBranchId()
     * @uses Rep::setSupportId()
     * @uses Rep::setLastLoginDatetime()
     * @uses Rep::setRepLoginName()
     * @uses Rep::setRepAddress()
     * @uses Rep::setRepPhoneNumber()
     * @uses Rep::setRepEmail()
     * @uses Rep::setRepRoleList()
     * @param int $repId
     * @param int $repDealerBranchId
     * @param int $supportId
     * @param string $lastLoginDatetime
     * @param string $repLoginName
     * @param \StructType\AddressWithName $repAddress
     * @param string $repPhoneNumber
     * @param string $repEmail
     * @param \ArrayType\ArrayOfRepRole $repRoleList
     */
    public function __construct($repId = null, $repDealerBranchId = null, $supportId = null, $lastLoginDatetime = null, $repLoginName = null, \StructType\AddressWithName $repAddress = null, $repPhoneNumber = null, $repEmail = null, \ArrayType\ArrayOfRepRole $repRoleList = null)
    {
        $this
            ->setRepId($repId)
            ->setRepDealerBranchId($repDealerBranchId)
            ->setSupportId($supportId)
            ->setLastLoginDatetime($lastLoginDatetime)
            ->setRepLoginName($repLoginName)
            ->setRepAddress($repAddress)
            ->setRepPhoneNumber($repPhoneNumber)
            ->setRepEmail($repEmail)
            ->setRepRoleList($repRoleList);
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\Rep
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get RepDealerBranchId value
     * @return int
     */
    public function getRepDealerBranchId()
    {
        return $this->RepDealerBranchId;
    }
    /**
     * Set RepDealerBranchId value
     * @param int $repDealerBranchId
     * @return \StructType\Rep
     */
    public function setRepDealerBranchId($repDealerBranchId = null)
    {
        // validation for constraint: int
        if (!is_null($repDealerBranchId) && !(is_int($repDealerBranchId) || ctype_digit($repDealerBranchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repDealerBranchId, true), gettype($repDealerBranchId)), __LINE__);
        }
        $this->RepDealerBranchId = $repDealerBranchId;
        return $this;
    }
    /**
     * Get SupportId value
     * @return int
     */
    public function getSupportId()
    {
        return $this->SupportId;
    }
    /**
     * Set SupportId value
     * @param int $supportId
     * @return \StructType\Rep
     */
    public function setSupportId($supportId = null)
    {
        // validation for constraint: int
        if (!is_null($supportId) && !(is_int($supportId) || ctype_digit($supportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supportId, true), gettype($supportId)), __LINE__);
        }
        $this->SupportId = $supportId;
        return $this;
    }
    /**
     * Get LastLoginDatetime value
     * @return string
     */
    public function getLastLoginDatetime()
    {
        return $this->LastLoginDatetime;
    }
    /**
     * Set LastLoginDatetime value
     * @param string $lastLoginDatetime
     * @return \StructType\Rep
     */
    public function setLastLoginDatetime($lastLoginDatetime = null)
    {
        // validation for constraint: string
        if (!is_null($lastLoginDatetime) && !is_string($lastLoginDatetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLoginDatetime, true), gettype($lastLoginDatetime)), __LINE__);
        }
        $this->LastLoginDatetime = $lastLoginDatetime;
        return $this;
    }
    /**
     * Get RepLoginName value
     * @return string|null
     */
    public function getRepLoginName()
    {
        return $this->RepLoginName;
    }
    /**
     * Set RepLoginName value
     * @param string $repLoginName
     * @return \StructType\Rep
     */
    public function setRepLoginName($repLoginName = null)
    {
        // validation for constraint: string
        if (!is_null($repLoginName) && !is_string($repLoginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repLoginName, true), gettype($repLoginName)), __LINE__);
        }
        $this->RepLoginName = $repLoginName;
        return $this;
    }
    /**
     * Get RepAddress value
     * @return \StructType\AddressWithName|null
     */
    public function getRepAddress()
    {
        return $this->RepAddress;
    }
    /**
     * Set RepAddress value
     * @param \StructType\AddressWithName $repAddress
     * @return \StructType\Rep
     */
    public function setRepAddress(\StructType\AddressWithName $repAddress = null)
    {
        $this->RepAddress = $repAddress;
        return $this;
    }
    /**
     * Get RepPhoneNumber value
     * @return string|null
     */
    public function getRepPhoneNumber()
    {
        return $this->RepPhoneNumber;
    }
    /**
     * Set RepPhoneNumber value
     * @param string $repPhoneNumber
     * @return \StructType\Rep
     */
    public function setRepPhoneNumber($repPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($repPhoneNumber) && !is_string($repPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repPhoneNumber, true), gettype($repPhoneNumber)), __LINE__);
        }
        $this->RepPhoneNumber = $repPhoneNumber;
        return $this;
    }
    /**
     * Get RepEmail value
     * @return string|null
     */
    public function getRepEmail()
    {
        return $this->RepEmail;
    }
    /**
     * Set RepEmail value
     * @param string $repEmail
     * @return \StructType\Rep
     */
    public function setRepEmail($repEmail = null)
    {
        // validation for constraint: string
        if (!is_null($repEmail) && !is_string($repEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repEmail, true), gettype($repEmail)), __LINE__);
        }
        $this->RepEmail = $repEmail;
        return $this;
    }
    /**
     * Get RepRoleList value
     * @return \ArrayType\ArrayOfRepRole|null
     */
    public function getRepRoleList()
    {
        return $this->RepRoleList;
    }
    /**
     * Set RepRoleList value
     * @param \ArrayType\ArrayOfRepRole $repRoleList
     * @return \StructType\Rep
     */
    public function setRepRoleList(\ArrayType\ArrayOfRepRole $repRoleList = null)
    {
        $this->RepRoleList = $repRoleList;
        return $this;
    }
}
