<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PanelVersion StructType
 * @subpackage Structs
 */
class PanelVersion extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Version;
    /**
     * The Panel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Panel;
    /**
     * Constructor method for PanelVersion
     * @uses PanelVersion::setVersion()
     * @uses PanelVersion::setPanel()
     * @param int $version
     * @param string $panel
     */
    public function __construct($version = null, $panel = null)
    {
        $this
            ->setVersion($version)
            ->setPanel($panel);
    }
    /**
     * Get Version value
     * @return int
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param int $version
     * @return \StructType\PanelVersion
     */
    public function setVersion($version = null)
    {
        // validation for constraint: int
        if (!is_null($version) && !(is_int($version) || ctype_digit($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Panel value
     * @return string|null
     */
    public function getPanel()
    {
        return $this->Panel;
    }
    /**
     * Set Panel value
     * @param string $panel
     * @return \StructType\PanelVersion
     */
    public function setPanel($panel = null)
    {
        // validation for constraint: string
        if (!is_null($panel) && !is_string($panel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($panel, true), gettype($panel)), __LINE__);
        }
        $this->Panel = $panel;
        return $this;
    }
}
