<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageTemplate StructType
 * @subpackage Structs
 */
class PackageTemplate extends AbstractStructBase
{
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TemplateId;
    /**
     * The ShowTemplateForAccountCreation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowTemplateForAccountCreation;
    /**
     * The MonthlyServiceFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MonthlyServiceFee;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BranchId;
    /**
     * The TemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The TemplateDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateDescription;
    /**
     * The TargetAudience
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetAudience;
    /**
     * The BasePackage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackageInfo
     */
    public $BasePackage;
    /**
     * The AddOnFeatures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAddOnFeatureInfo
     */
    public $AddOnFeatures;
    /**
     * Constructor method for PackageTemplate
     * @uses PackageTemplate::setTemplateId()
     * @uses PackageTemplate::setShowTemplateForAccountCreation()
     * @uses PackageTemplate::setMonthlyServiceFee()
     * @uses PackageTemplate::setBranchId()
     * @uses PackageTemplate::setTemplateName()
     * @uses PackageTemplate::setTemplateDescription()
     * @uses PackageTemplate::setTargetAudience()
     * @uses PackageTemplate::setBasePackage()
     * @uses PackageTemplate::setAddOnFeatures()
     * @param int $templateId
     * @param bool $showTemplateForAccountCreation
     * @param float $monthlyServiceFee
     * @param int $branchId
     * @param string $templateName
     * @param string $templateDescription
     * @param string $targetAudience
     * @param \StructType\PackageInfo $basePackage
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $addOnFeatures
     */
    public function __construct($templateId = null, $showTemplateForAccountCreation = null, $monthlyServiceFee = null, $branchId = null, $templateName = null, $templateDescription = null, $targetAudience = null, \StructType\PackageInfo $basePackage = null, \ArrayType\ArrayOfAddOnFeatureInfo $addOnFeatures = null)
    {
        $this
            ->setTemplateId($templateId)
            ->setShowTemplateForAccountCreation($showTemplateForAccountCreation)
            ->setMonthlyServiceFee($monthlyServiceFee)
            ->setBranchId($branchId)
            ->setTemplateName($templateName)
            ->setTemplateDescription($templateDescription)
            ->setTargetAudience($targetAudience)
            ->setBasePackage($basePackage)
            ->setAddOnFeatures($addOnFeatures);
    }
    /**
     * Get TemplateId value
     * @return int
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return \StructType\PackageTemplate
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !(is_int($templateId) || ctype_digit($templateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get ShowTemplateForAccountCreation value
     * @return bool
     */
    public function getShowTemplateForAccountCreation()
    {
        return $this->ShowTemplateForAccountCreation;
    }
    /**
     * Set ShowTemplateForAccountCreation value
     * @param bool $showTemplateForAccountCreation
     * @return \StructType\PackageTemplate
     */
    public function setShowTemplateForAccountCreation($showTemplateForAccountCreation = null)
    {
        // validation for constraint: boolean
        if (!is_null($showTemplateForAccountCreation) && !is_bool($showTemplateForAccountCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showTemplateForAccountCreation, true), gettype($showTemplateForAccountCreation)), __LINE__);
        }
        $this->ShowTemplateForAccountCreation = $showTemplateForAccountCreation;
        return $this;
    }
    /**
     * Get MonthlyServiceFee value
     * @return float
     */
    public function getMonthlyServiceFee()
    {
        return $this->MonthlyServiceFee;
    }
    /**
     * Set MonthlyServiceFee value
     * @param float $monthlyServiceFee
     * @return \StructType\PackageTemplate
     */
    public function setMonthlyServiceFee($monthlyServiceFee = null)
    {
        // validation for constraint: float
        if (!is_null($monthlyServiceFee) && !(is_float($monthlyServiceFee) || is_numeric($monthlyServiceFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($monthlyServiceFee, true), gettype($monthlyServiceFee)), __LINE__);
        }
        $this->MonthlyServiceFee = $monthlyServiceFee;
        return $this;
    }
    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }
    /**
     * Set BranchId value
     * @param int $branchId
     * @return \StructType\PackageTemplate
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\PackageTemplate
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateName, true), gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get TemplateDescription value
     * @return string|null
     */
    public function getTemplateDescription()
    {
        return $this->TemplateDescription;
    }
    /**
     * Set TemplateDescription value
     * @param string $templateDescription
     * @return \StructType\PackageTemplate
     */
    public function setTemplateDescription($templateDescription = null)
    {
        // validation for constraint: string
        if (!is_null($templateDescription) && !is_string($templateDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateDescription, true), gettype($templateDescription)), __LINE__);
        }
        $this->TemplateDescription = $templateDescription;
        return $this;
    }
    /**
     * Get TargetAudience value
     * @return string|null
     */
    public function getTargetAudience()
    {
        return $this->TargetAudience;
    }
    /**
     * Set TargetAudience value
     * @param string $targetAudience
     * @return \StructType\PackageTemplate
     */
    public function setTargetAudience($targetAudience = null)
    {
        // validation for constraint: string
        if (!is_null($targetAudience) && !is_string($targetAudience)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAudience, true), gettype($targetAudience)), __LINE__);
        }
        $this->TargetAudience = $targetAudience;
        return $this;
    }
    /**
     * Get BasePackage value
     * @return \StructType\PackageInfo|null
     */
    public function getBasePackage()
    {
        return $this->BasePackage;
    }
    /**
     * Set BasePackage value
     * @param \StructType\PackageInfo $basePackage
     * @return \StructType\PackageTemplate
     */
    public function setBasePackage(\StructType\PackageInfo $basePackage = null)
    {
        $this->BasePackage = $basePackage;
        return $this;
    }
    /**
     * Get AddOnFeatures value
     * @return \ArrayType\ArrayOfAddOnFeatureInfo|null
     */
    public function getAddOnFeatures()
    {
        return $this->AddOnFeatures;
    }
    /**
     * Set AddOnFeatures value
     * @param \ArrayType\ArrayOfAddOnFeatureInfo $addOnFeatures
     * @return \StructType\PackageTemplate
     */
    public function setAddOnFeatures(\ArrayType\ArrayOfAddOnFeatureInfo $addOnFeatures = null)
    {
        $this->AddOnFeatures = $addOnFeatures;
        return $this;
    }
}
