<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetWizardWebResponseInput StructType
 * @subpackage Structs
 */
class GetWizardWebResponseInput extends AbstractStructBase
{
    /**
     * The StartingStep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StartingStep;
    /**
     * The PartIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $PartIds;
    /**
     * Constructor method for GetWizardWebResponseInput
     * @uses GetWizardWebResponseInput::setStartingStep()
     * @uses GetWizardWebResponseInput::setPartIds()
     * @param int $startingStep
     * @param \ArrayType\ArrayOfString $partIds
     */
    public function __construct($startingStep = null, \ArrayType\ArrayOfString $partIds = null)
    {
        $this
            ->setStartingStep($startingStep)
            ->setPartIds($partIds);
    }
    /**
     * Get StartingStep value
     * @return int
     */
    public function getStartingStep()
    {
        return $this->StartingStep;
    }
    /**
     * Set StartingStep value
     * @param int $startingStep
     * @return \StructType\GetWizardWebResponseInput
     */
    public function setStartingStep($startingStep = null)
    {
        // validation for constraint: int
        if (!is_null($startingStep) && !(is_int($startingStep) || ctype_digit($startingStep))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingStep, true), gettype($startingStep)), __LINE__);
        }
        $this->StartingStep = $startingStep;
        return $this;
    }
    /**
     * Get PartIds value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getPartIds()
    {
        return $this->PartIds;
    }
    /**
     * Set PartIds value
     * @param \ArrayType\ArrayOfString $partIds
     * @return \StructType\GetWizardWebResponseInput
     */
    public function setPartIds(\ArrayType\ArrayOfString $partIds = null)
    {
        $this->PartIds = $partIds;
        return $this;
    }
}
