<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPackageIdsInput StructType
 * @subpackage Structs
 */
class GetPackageIdsInput extends AbstractStructBase
{
    /**
     * The DealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerId;
    /**
     * The accountType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accountType;
    /**
     * The CallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * Constructor method for GetPackageIdsInput
     * @uses GetPackageIdsInput::setDealerId()
     * @uses GetPackageIdsInput::setAccountType()
     * @uses GetPackageIdsInput::setCallerVersion()
     * @param int $dealerId
     * @param string $accountType
     * @param int $callerVersion
     */
    public function __construct($dealerId = null, $accountType = null, $callerVersion = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setAccountType($accountType)
            ->setCallerVersion($callerVersion);
    }
    /**
     * Get DealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->DealerId;
    }
    /**
     * Set DealerId value
     * @param int $dealerId
     * @return \StructType\GetPackageIdsInput
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->DealerId = $dealerId;
        return $this;
    }
    /**
     * Get accountType value
     * @return string
     */
    public function getAccountType()
    {
        return $this->accountType;
    }
    /**
     * Set accountType value
     * @uses \EnumType\AccountTypeEnum::valueIsValid()
     * @uses \EnumType\AccountTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountType
     * @return \StructType\GetPackageIdsInput
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountTypeEnum::valueIsValid($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountTypeEnum', is_array($accountType) ? implode(', ', $accountType) : var_export($accountType, true), implode(', ', \EnumType\AccountTypeEnum::getValidValues())), __LINE__);
        }
        $this->accountType = $accountType;
        return $this;
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \StructType\GetPackageIdsInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !(is_int($callerVersion) || ctype_digit($callerVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callerVersion, true), gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
}
