<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCurrentRepInfoInput StructType
 * @subpackage Structs
 */
class GetCurrentRepInfoInput extends AbstractStructBase
{
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $RepId;
    /**
     * The RepLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepLogin;
    /**
     * The RepPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RepPassword;
    /**
     * Constructor method for GetCurrentRepInfoInput
     * @uses GetCurrentRepInfoInput::setRepId()
     * @uses GetCurrentRepInfoInput::setRepLogin()
     * @uses GetCurrentRepInfoInput::setRepPassword()
     * @param int $repId
     * @param string $repLogin
     * @param string $repPassword
     */
    public function __construct($repId = null, $repLogin = null, $repPassword = null)
    {
        $this
            ->setRepId($repId)
            ->setRepLogin($repLogin)
            ->setRepPassword($repPassword);
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\GetCurrentRepInfoInput
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get RepLogin value
     * @return string|null
     */
    public function getRepLogin()
    {
        return $this->RepLogin;
    }
    /**
     * Set RepLogin value
     * @param string $repLogin
     * @return \StructType\GetCurrentRepInfoInput
     */
    public function setRepLogin($repLogin = null)
    {
        // validation for constraint: string
        if (!is_null($repLogin) && !is_string($repLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repLogin, true), gettype($repLogin)), __LINE__);
        }
        $this->RepLogin = $repLogin;
        return $this;
    }
    /**
     * Get RepPassword value
     * @return string|null
     */
    public function getRepPassword()
    {
        return $this->RepPassword;
    }
    /**
     * Set RepPassword value
     * @param string $repPassword
     * @return \StructType\GetCurrentRepInfoInput
     */
    public function setRepPassword($repPassword = null)
    {
        // validation for constraint: string
        if (!is_null($repPassword) && !is_string($repPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repPassword, true), gettype($repPassword)), __LINE__);
        }
        $this->RepPassword = $repPassword;
        return $this;
    }
}
