<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBuilderProgramsOutput StructType
 * @subpackage Structs
 */
class GetBuilderProgramsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Programs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBuilderProgramInfo
     */
    public $Programs;
    /**
     * Constructor method for GetBuilderProgramsOutput
     * @uses GetBuilderProgramsOutput::setSuccess()
     * @uses GetBuilderProgramsOutput::setErrorMessage()
     * @uses GetBuilderProgramsOutput::setPrograms()
     * @param bool $success
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfBuilderProgramInfo $programs
     */
    public function __construct($success = null, $errorMessage = null, \ArrayType\ArrayOfBuilderProgramInfo $programs = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setPrograms($programs);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetBuilderProgramsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetBuilderProgramsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Programs value
     * @return \ArrayType\ArrayOfBuilderProgramInfo|null
     */
    public function getPrograms()
    {
        return $this->Programs;
    }
    /**
     * Set Programs value
     * @param \ArrayType\ArrayOfBuilderProgramInfo $programs
     * @return \StructType\GetBuilderProgramsOutput
     */
    public function setPrograms(\ArrayType\ArrayOfBuilderProgramInfo $programs = null)
    {
        $this->Programs = $programs;
        return $this;
    }
}
