<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBinderContentsOutput StructType
 * @subpackage Structs
 */
class GetBinderContentsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The Resources
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfMyBinderResourceItemModel
     */
    public $Resources;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for GetBinderContentsOutput
     * @uses GetBinderContentsOutput::setSuccess()
     * @uses GetBinderContentsOutput::setResources()
     * @uses GetBinderContentsOutput::setErrorMessage()
     * @param bool $success
     * @param \ArrayType\ArrayOfMyBinderResourceItemModel $resources
     * @param string $errorMessage
     */
    public function __construct($success = null, \ArrayType\ArrayOfMyBinderResourceItemModel $resources = null, $errorMessage = null)
    {
        $this
            ->setSuccess($success)
            ->setResources($resources)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\GetBinderContentsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Resources value
     * @return \ArrayType\ArrayOfMyBinderResourceItemModel|null
     */
    public function getResources()
    {
        return $this->Resources;
    }
    /**
     * Set Resources value
     * @param \ArrayType\ArrayOfMyBinderResourceItemModel $resources
     * @return \StructType\GetBinderContentsOutput
     */
    public function setResources(\ArrayType\ArrayOfMyBinderResourceItemModel $resources = null)
    {
        $this->Resources = $resources;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetBinderContentsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
