<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateRepLoginUrlForSSOMobileTechAppInput StructType
 * @subpackage Structs
 */
class GenerateRepLoginUrlForSSOMobileTechAppInput extends BaseGenerateRepLoginUrlForSSOMobileTechAppInput
{
    /**
     * The RepId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RepId;
    /**
     * The Page
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Page;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerId;
    /**
     * The TargetUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetUrl;
    /**
     * Constructor method for GenerateRepLoginUrlForSSOMobileTechAppInput
     * @uses GenerateRepLoginUrlForSSOMobileTechAppInput::setRepId()
     * @uses GenerateRepLoginUrlForSSOMobileTechAppInput::setPage()
     * @uses GenerateRepLoginUrlForSSOMobileTechAppInput::setCustomerId()
     * @uses GenerateRepLoginUrlForSSOMobileTechAppInput::setTargetUrl()
     * @param int $repId
     * @param string $page
     * @param int $customerId
     * @param string $targetUrl
     */
    public function __construct($repId = null, $page = null, $customerId = null, $targetUrl = null)
    {
        $this
            ->setRepId($repId)
            ->setPage($page)
            ->setCustomerId($customerId)
            ->setTargetUrl($targetUrl);
    }
    /**
     * Get RepId value
     * @return int
     */
    public function getRepId()
    {
        return $this->RepId;
    }
    /**
     * Set RepId value
     * @param int $repId
     * @return \StructType\GenerateRepLoginUrlForSSOMobileTechAppInput
     */
    public function setRepId($repId = null)
    {
        // validation for constraint: int
        if (!is_null($repId) && !(is_int($repId) || ctype_digit($repId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($repId, true), gettype($repId)), __LINE__);
        }
        $this->RepId = $repId;
        return $this;
    }
    /**
     * Get Page value
     * @return string
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @uses \EnumType\MobileAdminPageUrlEnum::valueIsValid()
     * @uses \EnumType\MobileAdminPageUrlEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $page
     * @return \StructType\GenerateRepLoginUrlForSSOMobileTechAppInput
     */
    public function setPage($page = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MobileAdminPageUrlEnum::valueIsValid($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MobileAdminPageUrlEnum', is_array($page) ? implode(', ', $page) : var_export($page, true), implode(', ', \EnumType\MobileAdminPageUrlEnum::getValidValues())), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\GenerateRepLoginUrlForSSOMobileTechAppInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get TargetUrl value
     * @return string|null
     */
    public function getTargetUrl()
    {
        return $this->TargetUrl;
    }
    /**
     * Set TargetUrl value
     * @param string $targetUrl
     * @return \StructType\GenerateRepLoginUrlForSSOMobileTechAppInput
     */
    public function setTargetUrl($targetUrl = null)
    {
        // validation for constraint: string
        if (!is_null($targetUrl) && !is_string($targetUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetUrl, true), gettype($targetUrl)), __LINE__);
        }
        $this->TargetUrl = $targetUrl;
        return $this;
    }
}
