<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DealerCustomUpload StructType
 * @subpackage Structs
 */
class DealerCustomUpload extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The FileSizeKbs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FileSizeKbs;
    /**
     * The FileUploadStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileUploadStatus;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for DealerCustomUpload
     * @uses DealerCustomUpload::setID()
     * @uses DealerCustomUpload::setFileSizeKbs()
     * @uses DealerCustomUpload::setFileUploadStatus()
     * @uses DealerCustomUpload::setFileName()
     * @param int $iD
     * @param int $fileSizeKbs
     * @param string $fileUploadStatus
     * @param string $fileName
     */
    public function __construct($iD = null, $fileSizeKbs = null, $fileUploadStatus = null, $fileName = null)
    {
        $this
            ->setID($iD)
            ->setFileSizeKbs($fileSizeKbs)
            ->setFileUploadStatus($fileUploadStatus)
            ->setFileName($fileName);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DealerCustomUpload
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get FileSizeKbs value
     * @return int
     */
    public function getFileSizeKbs()
    {
        return $this->FileSizeKbs;
    }
    /**
     * Set FileSizeKbs value
     * @param int $fileSizeKbs
     * @return \StructType\DealerCustomUpload
     */
    public function setFileSizeKbs($fileSizeKbs = null)
    {
        // validation for constraint: int
        if (!is_null($fileSizeKbs) && !(is_int($fileSizeKbs) || ctype_digit($fileSizeKbs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSizeKbs, true), gettype($fileSizeKbs)), __LINE__);
        }
        $this->FileSizeKbs = $fileSizeKbs;
        return $this;
    }
    /**
     * Get FileUploadStatus value
     * @return string|null
     */
    public function getFileUploadStatus()
    {
        return $this->FileUploadStatus;
    }
    /**
     * Set FileUploadStatus value
     * @param string $fileUploadStatus
     * @return \StructType\DealerCustomUpload
     */
    public function setFileUploadStatus($fileUploadStatus = null)
    {
        // validation for constraint: string
        if (!is_null($fileUploadStatus) && !is_string($fileUploadStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileUploadStatus, true), gettype($fileUploadStatus)), __LINE__);
        }
        $this->FileUploadStatus = $fileUploadStatus;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\DealerCustomUpload
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
}
