<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerUnsubscribes StructType
 * @subpackage Structs
 */
class CustomerUnsubscribes extends AbstractStructBase
{
    /**
     * The LoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The ENewsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ENewsSubscribed;
    /**
     * The ProductAnnouncementsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ProductAnnouncementsSubscribed;
    /**
     * The PromotionsSubscribed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PromotionsSubscribed;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AlternateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AlternateId;
    /**
     * Constructor method for CustomerUnsubscribes
     * @uses CustomerUnsubscribes::setLoginId()
     * @uses CustomerUnsubscribes::setCustomerId()
     * @uses CustomerUnsubscribes::setENewsSubscribed()
     * @uses CustomerUnsubscribes::setProductAnnouncementsSubscribed()
     * @uses CustomerUnsubscribes::setPromotionsSubscribed()
     * @uses CustomerUnsubscribes::setEmail()
     * @uses CustomerUnsubscribes::setAccountNumber()
     * @uses CustomerUnsubscribes::setAlternateId()
     * @param int $loginId
     * @param int $customerId
     * @param bool $eNewsSubscribed
     * @param bool $productAnnouncementsSubscribed
     * @param bool $promotionsSubscribed
     * @param string $email
     * @param string $accountNumber
     * @param string $alternateId
     */
    public function __construct($loginId = null, $customerId = null, $eNewsSubscribed = null, $productAnnouncementsSubscribed = null, $promotionsSubscribed = null, $email = null, $accountNumber = null, $alternateId = null)
    {
        $this
            ->setLoginId($loginId)
            ->setCustomerId($customerId)
            ->setENewsSubscribed($eNewsSubscribed)
            ->setProductAnnouncementsSubscribed($productAnnouncementsSubscribed)
            ->setPromotionsSubscribed($promotionsSubscribed)
            ->setEmail($email)
            ->setAccountNumber($accountNumber)
            ->setAlternateId($alternateId);
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \StructType\CustomerUnsubscribes
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \StructType\CustomerUnsubscribes
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get ENewsSubscribed value
     * @return bool
     */
    public function getENewsSubscribed()
    {
        return $this->ENewsSubscribed;
    }
    /**
     * Set ENewsSubscribed value
     * @param bool $eNewsSubscribed
     * @return \StructType\CustomerUnsubscribes
     */
    public function setENewsSubscribed($eNewsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($eNewsSubscribed) && !is_bool($eNewsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eNewsSubscribed, true), gettype($eNewsSubscribed)), __LINE__);
        }
        $this->ENewsSubscribed = $eNewsSubscribed;
        return $this;
    }
    /**
     * Get ProductAnnouncementsSubscribed value
     * @return bool
     */
    public function getProductAnnouncementsSubscribed()
    {
        return $this->ProductAnnouncementsSubscribed;
    }
    /**
     * Set ProductAnnouncementsSubscribed value
     * @param bool $productAnnouncementsSubscribed
     * @return \StructType\CustomerUnsubscribes
     */
    public function setProductAnnouncementsSubscribed($productAnnouncementsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($productAnnouncementsSubscribed) && !is_bool($productAnnouncementsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($productAnnouncementsSubscribed, true), gettype($productAnnouncementsSubscribed)), __LINE__);
        }
        $this->ProductAnnouncementsSubscribed = $productAnnouncementsSubscribed;
        return $this;
    }
    /**
     * Get PromotionsSubscribed value
     * @return bool
     */
    public function getPromotionsSubscribed()
    {
        return $this->PromotionsSubscribed;
    }
    /**
     * Set PromotionsSubscribed value
     * @param bool $promotionsSubscribed
     * @return \StructType\CustomerUnsubscribes
     */
    public function setPromotionsSubscribed($promotionsSubscribed = null)
    {
        // validation for constraint: boolean
        if (!is_null($promotionsSubscribed) && !is_bool($promotionsSubscribed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($promotionsSubscribed, true), gettype($promotionsSubscribed)), __LINE__);
        }
        $this->PromotionsSubscribed = $promotionsSubscribed;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\CustomerUnsubscribes
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\CustomerUnsubscribes
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AlternateId value
     * @return string|null
     */
    public function getAlternateId()
    {
        return $this->AlternateId;
    }
    /**
     * Set AlternateId value
     * @param string $alternateId
     * @return \StructType\CustomerUnsubscribes
     */
    public function setAlternateId($alternateId = null)
    {
        // validation for constraint: string
        if (!is_null($alternateId) && !is_string($alternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateId, true), gettype($alternateId)), __LINE__);
        }
        $this->AlternateId = $alternateId;
        return $this;
    }
}
