<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateSupportTicketForDealer StructType
 * @subpackage Structs
 */
class CreateSupportTicketForDealer extends AbstractStructBase
{
    /**
     * The dealerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $dealerId;
    /**
     * The input
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreateSupportTicketForDealerInput
     */
    public $input;
    /**
     * Constructor method for CreateSupportTicketForDealer
     * @uses CreateSupportTicketForDealer::setDealerId()
     * @uses CreateSupportTicketForDealer::setInput()
     * @param int $dealerId
     * @param \StructType\CreateSupportTicketForDealerInput $input
     */
    public function __construct($dealerId = null, \StructType\CreateSupportTicketForDealerInput $input = null)
    {
        $this
            ->setDealerId($dealerId)
            ->setInput($input);
    }
    /**
     * Get dealerId value
     * @return int
     */
    public function getDealerId()
    {
        return $this->dealerId;
    }
    /**
     * Set dealerId value
     * @param int $dealerId
     * @return \StructType\CreateSupportTicketForDealer
     */
    public function setDealerId($dealerId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerId) && !(is_int($dealerId) || ctype_digit($dealerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerId, true), gettype($dealerId)), __LINE__);
        }
        $this->dealerId = $dealerId;
        return $this;
    }
    /**
     * Get input value
     * @return \StructType\CreateSupportTicketForDealerInput|null
     */
    public function getInput()
    {
        return $this->input;
    }
    /**
     * Set input value
     * @param \StructType\CreateSupportTicketForDealerInput $input
     * @return \StructType\CreateSupportTicketForDealer
     */
    public function setInput(\StructType\CreateSupportTicketForDealerInput $input = null)
    {
        $this->input = $input;
        return $this;
    }
}
