<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOnFeatureInfo StructType
 * @subpackage Structs
 */
class AddOnFeatureInfo extends AbstractStructBase
{
    /**
     * The Feature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Feature;
    /**
     * The MaxQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxQuantity;
    /**
     * Constructor method for AddOnFeatureInfo
     * @uses AddOnFeatureInfo::setFeature()
     * @uses AddOnFeatureInfo::setMaxQuantity()
     * @param string $feature
     * @param int $maxQuantity
     */
    public function __construct($feature = null, $maxQuantity = null)
    {
        $this
            ->setFeature($feature)
            ->setMaxQuantity($maxQuantity);
    }
    /**
     * Get Feature value
     * @return string
     */
    public function getFeature()
    {
        return $this->Feature;
    }
    /**
     * Set Feature value
     * @uses \EnumType\AddOnFeatureEnum::valueIsValid()
     * @uses \EnumType\AddOnFeatureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $feature
     * @return \StructType\AddOnFeatureInfo
     */
    public function setFeature($feature = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AddOnFeatureEnum::valueIsValid($feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AddOnFeatureEnum', is_array($feature) ? implode(', ', $feature) : var_export($feature, true), implode(', ', \EnumType\AddOnFeatureEnum::getValidValues())), __LINE__);
        }
        $this->Feature = $feature;
        return $this;
    }
    /**
     * Get MaxQuantity value
     * @return int
     */
    public function getMaxQuantity()
    {
        return $this->MaxQuantity;
    }
    /**
     * Set MaxQuantity value
     * @param int $maxQuantity
     * @return \StructType\AddOnFeatureInfo
     */
    public function setMaxQuantity($maxQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxQuantity) && !(is_int($maxQuantity) || ctype_digit($maxQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxQuantity, true), gettype($maxQuantity)), __LINE__);
        }
        $this->MaxQuantity = $maxQuantity;
        return $this;
    }
}
