<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CreateRepLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateRepLogin $parameters
     * @return \StructType\CreateRepLoginResponse|bool
     */
    public function CreateRepLogin(\StructType\CreateRepLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateRepLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBranch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateBranch $parameters
     * @return \StructType\CreateBranchResponse|bool
     */
    public function CreateBranch(\StructType\CreateBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSeamlessLoginTokenForRep
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Create seamless login token for the logged-in rep
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSeamlessLoginTokenForRep $parameters
     * @return \StructType\CreateSeamlessLoginTokenForRepResponse|bool
     */
    public function CreateSeamlessLoginTokenForRep(\StructType\CreateSeamlessLoginTokenForRep $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSeamlessLoginTokenForRep($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSupportTicket
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Creates a support ticket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSupportTicket $parameters
     * @return \StructType\CreateSupportTicketResponse|bool
     */
    public function CreateSupportTicket(\StructType\CreateSupportTicket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSupportTicket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSupportTicketForDealer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Creates a support ticket for a Dealer. Dealers should call CreateSupportTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateSupportTicketForDealer $parameters
     * @return \StructType\CreateSupportTicketForDealerResponse|bool
     */
    public function CreateSupportTicketForDealer(\StructType\CreateSupportTicketForDealer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSupportTicketForDealer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateBranchResponse|\StructType\CreateRepLoginResponse|\StructType\CreateSeamlessLoginTokenForRepResponse|\StructType\CreateSupportTicketForDealerResponse|\StructType\CreateSupportTicketResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
