<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPackageInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfPackageInfo extends AbstractStructArrayBase
{
    /**
     * The PackageInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PackageInfo[]
     */
    public $PackageInfo;
    /**
     * Constructor method for ArrayOfPackageInfo
     * @uses ArrayOfPackageInfo::setPackageInfo()
     * @param \StructType\PackageInfo[] $packageInfo
     */
    public function __construct(array $packageInfo = array())
    {
        $this
            ->setPackageInfo($packageInfo);
    }
    /**
     * Get PackageInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PackageInfo[]|null
     */
    public function getPackageInfo()
    {
        return isset($this->PackageInfo) ? $this->PackageInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageInfoForArrayConstraintsFromSetPackageInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPackageInfoPackageInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPackageInfoPackageInfoItem instanceof \StructType\PackageInfo) {
                $invalidValues[] = is_object($arrayOfPackageInfoPackageInfoItem) ? get_class($arrayOfPackageInfoPackageInfoItem) : sprintf('%s(%s)', gettype($arrayOfPackageInfoPackageInfoItem), var_export($arrayOfPackageInfoPackageInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageInfo property can only contain items of type \StructType\PackageInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackageInfo[] $packageInfo
     * @return \ArrayType\ArrayOfPackageInfo
     */
    public function setPackageInfo(array $packageInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($packageInfoArrayErrorMessage = self::validatePackageInfoForArrayConstraintsFromSetPackageInfo($packageInfo))) {
            throw new \InvalidArgumentException($packageInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($packageInfo) || (is_array($packageInfo) && empty($packageInfo))) {
            unset($this->PackageInfo);
        } else {
            $this->PackageInfo = $packageInfo;
        }
        return $this;
    }
    /**
     * Add item to PackageInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageInfo $item
     * @return \ArrayType\ArrayOfPackageInfo
     */
    public function addToPackageInfo(\StructType\PackageInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageInfo) {
            throw new \InvalidArgumentException(sprintf('The PackageInfo property can only contain items of type \StructType\PackageInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PackageInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PackageInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PackageInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PackageInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PackageInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PackageInfo
     */
    public function getAttributeName()
    {
        return 'PackageInfo';
    }
}
