<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SDT_ConsultaProtocoloIn StructType
 * @subpackage Structs
 */
class SDT_ConsultaProtocoloIn extends AbstractStructBase
{
    /**
     * The Protocolo
     * @var string
     */
    public $Protocolo;
    /**
     * The Login
     * @var \StructType\SDT_ConsultaProtocoloIn_Login
     */
    public $Login;
    /**
     * Constructor method for SDT_ConsultaProtocoloIn
     * @uses SDT_ConsultaProtocoloIn::setProtocolo()
     * @uses SDT_ConsultaProtocoloIn::setLogin()
     * @param string $protocolo
     * @param \StructType\SDT_ConsultaProtocoloIn_Login $login
     */
    public function __construct($protocolo = null, \StructType\SDT_ConsultaProtocoloIn_Login $login = null)
    {
        $this
            ->setProtocolo($protocolo)
            ->setLogin($login);
    }
    /**
     * Get Protocolo value
     * @return string|null
     */
    public function getProtocolo()
    {
        return $this->Protocolo;
    }
    /**
     * Set Protocolo value
     * @param string $protocolo
     * @return \StructType\SDT_ConsultaProtocoloIn
     */
    public function setProtocolo($protocolo = null)
    {
        // validation for constraint: string
        if (!is_null($protocolo) && !is_string($protocolo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocolo, true), gettype($protocolo)), __LINE__);
        }
        $this->Protocolo = $protocolo;
        return $this;
    }
    /**
     * Get Login value
     * @return \StructType\SDT_ConsultaProtocoloIn_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\SDT_ConsultaProtocoloIn_Login $login
     * @return \StructType\SDT_ConsultaProtocoloIn
     */
    public function setLogin(\StructType\SDT_ConsultaProtocoloIn_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
}
