<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_TimeCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_TimeCode
 * @subpackage Structs
 */
class XML_TimeCode extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The TimeCodeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeCodeDescription;
    /**
     * The TimeCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeCodeID;
    /**
     * Constructor method for XML_TimeCode
     * @uses XML_TimeCode::setCompanyID()
     * @uses XML_TimeCode::setTimeCodeDescription()
     * @uses XML_TimeCode::setTimeCodeID()
     * @param int $companyID
     * @param string $timeCodeDescription
     * @param int $timeCodeID
     */
    public function __construct($companyID = null, $timeCodeDescription = null, $timeCodeID = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setTimeCodeDescription($timeCodeDescription)
            ->setTimeCodeID($timeCodeID);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_TimeCode
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get TimeCodeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeCodeDescription()
    {
        return isset($this->TimeCodeDescription) ? $this->TimeCodeDescription : null;
    }
    /**
     * Set TimeCodeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeCodeDescription
     * @return \App\Symmetry\Entities\StructType\XML_TimeCode
     */
    public function setTimeCodeDescription($timeCodeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($timeCodeDescription) && !is_string($timeCodeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeCodeDescription, true), gettype($timeCodeDescription)), __LINE__);
        }
        if (is_null($timeCodeDescription) || (is_array($timeCodeDescription) && empty($timeCodeDescription))) {
            unset($this->TimeCodeDescription);
        } else {
            $this->TimeCodeDescription = $timeCodeDescription;
        }
        return $this;
    }
    /**
     * Get TimeCodeID value
     * @return int|null
     */
    public function getTimeCodeID()
    {
        return $this->TimeCodeID;
    }
    /**
     * Set TimeCodeID value
     * @param int $timeCodeID
     * @return \App\Symmetry\Entities\StructType\XML_TimeCode
     */
    public function setTimeCodeID($timeCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($timeCodeID) && !(is_int($timeCodeID) || ctype_digit($timeCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeCodeID, true), gettype($timeCodeID)), __LINE__);
        }
        $this->TimeCodeID = $timeCodeID;
        return $this;
    }
}
