<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataAccessRights StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataAccessRights
 * @subpackage Structs
 */
class XML_ImportDataAccessRights extends AbstractStructBase
{
    /**
     * The AccessGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessGroupID;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AreaID;
    /**
     * The ReaderGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderGroupID;
    /**
     * The ReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderID;
    /**
     * The TimeCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeCodeID;
    /**
     * Constructor method for XML_ImportDataAccessRights
     * @uses XML_ImportDataAccessRights::setAccessGroupID()
     * @uses XML_ImportDataAccessRights::setAreaID()
     * @uses XML_ImportDataAccessRights::setReaderGroupID()
     * @uses XML_ImportDataAccessRights::setReaderID()
     * @uses XML_ImportDataAccessRights::setTimeCodeID()
     * @param int $accessGroupID
     * @param int $areaID
     * @param int $readerGroupID
     * @param int $readerID
     * @param int $timeCodeID
     */
    public function __construct($accessGroupID = null, $areaID = null, $readerGroupID = null, $readerID = null, $timeCodeID = null)
    {
        $this
            ->setAccessGroupID($accessGroupID)
            ->setAreaID($areaID)
            ->setReaderGroupID($readerGroupID)
            ->setReaderID($readerID)
            ->setTimeCodeID($timeCodeID);
    }
    /**
     * Get AccessGroupID value
     * @return int|null
     */
    public function getAccessGroupID()
    {
        return $this->AccessGroupID;
    }
    /**
     * Set AccessGroupID value
     * @param int $accessGroupID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataAccessRights
     */
    public function setAccessGroupID($accessGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($accessGroupID) && !(is_int($accessGroupID) || ctype_digit($accessGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessGroupID, true), gettype($accessGroupID)), __LINE__);
        }
        $this->AccessGroupID = $accessGroupID;
        return $this;
    }
    /**
     * Get AreaID value
     * @return int|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param int $areaID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataAccessRights
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: int
        if (!is_null($areaID) && !(is_int($areaID) || ctype_digit($areaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Get ReaderGroupID value
     * @return int|null
     */
    public function getReaderGroupID()
    {
        return $this->ReaderGroupID;
    }
    /**
     * Set ReaderGroupID value
     * @param int $readerGroupID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataAccessRights
     */
    public function setReaderGroupID($readerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($readerGroupID) && !(is_int($readerGroupID) || ctype_digit($readerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerGroupID, true), gettype($readerGroupID)), __LINE__);
        }
        $this->ReaderGroupID = $readerGroupID;
        return $this;
    }
    /**
     * Get ReaderID value
     * @return int|null
     */
    public function getReaderID()
    {
        return $this->ReaderID;
    }
    /**
     * Set ReaderID value
     * @param int $readerID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataAccessRights
     */
    public function setReaderID($readerID = null)
    {
        // validation for constraint: int
        if (!is_null($readerID) && !(is_int($readerID) || ctype_digit($readerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerID, true), gettype($readerID)), __LINE__);
        }
        $this->ReaderID = $readerID;
        return $this;
    }
    /**
     * Get TimeCodeID value
     * @return int|null
     */
    public function getTimeCodeID()
    {
        return $this->TimeCodeID;
    }
    /**
     * Set TimeCodeID value
     * @param int $timeCodeID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataAccessRights
     */
    public function setTimeCodeID($timeCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($timeCodeID) && !(is_int($timeCodeID) || ctype_digit($timeCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeCodeID, true), gettype($timeCodeID)), __LINE__);
        }
        $this->TimeCodeID = $timeCodeID;
        return $this;
    }
}
