<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_GetDeviceCommandRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_GetDeviceCommandRequest
 * @subpackage Structs
 */
class XML_GetDeviceCommandRequest extends AbstractStructBase
{
    /**
     * The CommandType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandType;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceType;
    /**
     * Constructor method for XML_GetDeviceCommandRequest
     * @uses XML_GetDeviceCommandRequest::setCommandType()
     * @uses XML_GetDeviceCommandRequest::setDeviceID()
     * @uses XML_GetDeviceCommandRequest::setDeviceType()
     * @param string $commandType
     * @param int $deviceID
     * @param string $deviceType
     */
    public function __construct($commandType = null, $deviceID = null, $deviceType = null)
    {
        $this
            ->setCommandType($commandType)
            ->setDeviceID($deviceID)
            ->setDeviceType($deviceType);
    }
    /**
     * Get CommandType value
     * @return string|null
     */
    public function getCommandType()
    {
        return $this->CommandType;
    }
    /**
     * Set CommandType value
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commandType
     * @return \App\Symmetry\Entities\StructType\XML_GetDeviceCommandRequest
     */
    public function setCommandType($commandType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid($commandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnCommandType', is_array($commandType) ? implode(', ', $commandType) : var_export($commandType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues())), __LINE__);
        }
        $this->CommandType = $commandType;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_GetDeviceCommandRequest
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_GetDeviceCommandRequest
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
}
