<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditReaderGroupDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditReaderGroupDocument
 * @subpackage Structs
 */
class XML_EditReaderGroupDocument extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The EditModeEnumerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EditModeEnumerated;
    /**
     * The ReaderGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderGroupID;
    /**
     * The ReaderGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReaderGroupName;
    /**
     * The Readers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader
     */
    public $Readers;
    /**
     * Constructor method for XML_EditReaderGroupDocument
     * @uses XML_EditReaderGroupDocument::setCompanyID()
     * @uses XML_EditReaderGroupDocument::setEditModeEnumerated()
     * @uses XML_EditReaderGroupDocument::setReaderGroupID()
     * @uses XML_EditReaderGroupDocument::setReaderGroupName()
     * @uses XML_EditReaderGroupDocument::setReaders()
     * @param int $companyID
     * @param string $editModeEnumerated
     * @param int $readerGroupID
     * @param string $readerGroupName
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers
     */
    public function __construct($companyID = null, $editModeEnumerated = null, $readerGroupID = null, $readerGroupName = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setEditModeEnumerated($editModeEnumerated)
            ->setReaderGroupID($readerGroupID)
            ->setReaderGroupName($readerGroupName)
            ->setReaders($readers);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroupDocument
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EditModeEnumerated value
     * @return string|null
     */
    public function getEditModeEnumerated()
    {
        return $this->EditModeEnumerated;
    }
    /**
     * Set EditModeEnumerated value
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editModeEnumerated
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroupDocument
     */
    public function setEditModeEnumerated($editModeEnumerated = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid($editModeEnumerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnEditMode', is_array($editModeEnumerated) ? implode(', ', $editModeEnumerated) : var_export($editModeEnumerated, true), implode(', ', \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues())), __LINE__);
        }
        $this->EditModeEnumerated = $editModeEnumerated;
        return $this;
    }
    /**
     * Get ReaderGroupID value
     * @return int|null
     */
    public function getReaderGroupID()
    {
        return $this->ReaderGroupID;
    }
    /**
     * Set ReaderGroupID value
     * @param int $readerGroupID
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroupDocument
     */
    public function setReaderGroupID($readerGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($readerGroupID) && !(is_int($readerGroupID) || ctype_digit($readerGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerGroupID, true), gettype($readerGroupID)), __LINE__);
        }
        $this->ReaderGroupID = $readerGroupID;
        return $this;
    }
    /**
     * Get ReaderGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReaderGroupName()
    {
        return isset($this->ReaderGroupName) ? $this->ReaderGroupName : null;
    }
    /**
     * Set ReaderGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $readerGroupName
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroupDocument
     */
    public function setReaderGroupName($readerGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($readerGroupName) && !is_string($readerGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readerGroupName, true), gettype($readerGroupName)), __LINE__);
        }
        if (is_null($readerGroupName) || (is_array($readerGroupName) && empty($readerGroupName))) {
            unset($this->ReaderGroupName);
        } else {
            $this->ReaderGroupName = $readerGroupName;
        }
        return $this;
    }
    /**
     * Get Readers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader|null
     */
    public function getReaders()
    {
        return isset($this->Readers) ? $this->Readers : null;
    }
    /**
     * Set Readers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers
     * @return \App\Symmetry\Entities\StructType\XML_EditReaderGroupDocument
     */
    public function setReaders(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers = null)
    {
        if (is_null($readers) || (is_array($readers) && empty($readers))) {
            unset($this->Readers);
        } else {
            $this->Readers = $readers;
        }
        return $this;
    }
}
