<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditFloorGroup StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditFloorGroup
 * @subpackage Structs
 */
class XML_EditFloorGroup extends AbstractStructBase
{
    /**
     * The FloorGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FloorGroupID;
    /**
     * The TimeCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TimeCodeID;
    /**
     * Constructor method for XML_EditFloorGroup
     * @uses XML_EditFloorGroup::setFloorGroupID()
     * @uses XML_EditFloorGroup::setTimeCodeID()
     * @param int $floorGroupID
     * @param int $timeCodeID
     */
    public function __construct($floorGroupID = null, $timeCodeID = null)
    {
        $this
            ->setFloorGroupID($floorGroupID)
            ->setTimeCodeID($timeCodeID);
    }
    /**
     * Get FloorGroupID value
     * @return int|null
     */
    public function getFloorGroupID()
    {
        return $this->FloorGroupID;
    }
    /**
     * Set FloorGroupID value
     * @param int $floorGroupID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroup
     */
    public function setFloorGroupID($floorGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($floorGroupID) && !(is_int($floorGroupID) || ctype_digit($floorGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floorGroupID, true), gettype($floorGroupID)), __LINE__);
        }
        $this->FloorGroupID = $floorGroupID;
        return $this;
    }
    /**
     * Get TimeCodeID value
     * @return int|null
     */
    public function getTimeCodeID()
    {
        return $this->TimeCodeID;
    }
    /**
     * Set TimeCodeID value
     * @param int $timeCodeID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroup
     */
    public function setTimeCodeID($timeCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($timeCodeID) && !(is_int($timeCodeID) || ctype_digit($timeCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeCodeID, true), gettype($timeCodeID)), __LINE__);
        }
        $this->TimeCodeID = $timeCodeID;
        return $this;
    }
}
