<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CurrentAntiPassbackForCardHolder StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CurrentAntiPassbackForCardHolder
 * @subpackage Structs
 */
class XML_CurrentAntiPassbackForCardHolder extends AbstractStructBase
{
    /**
     * The AntiPassbackZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AntiPassbackZone;
    /**
     * The ReaderDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReaderDescription;
    /**
     * The ReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReaderID;
    /**
     * Constructor method for XML_CurrentAntiPassbackForCardHolder
     * @uses XML_CurrentAntiPassbackForCardHolder::setAntiPassbackZone()
     * @uses XML_CurrentAntiPassbackForCardHolder::setReaderDescription()
     * @uses XML_CurrentAntiPassbackForCardHolder::setReaderID()
     * @param int $antiPassbackZone
     * @param string $readerDescription
     * @param int $readerID
     */
    public function __construct($antiPassbackZone = null, $readerDescription = null, $readerID = null)
    {
        $this
            ->setAntiPassbackZone($antiPassbackZone)
            ->setReaderDescription($readerDescription)
            ->setReaderID($readerID);
    }
    /**
     * Get AntiPassbackZone value
     * @return int|null
     */
    public function getAntiPassbackZone()
    {
        return $this->AntiPassbackZone;
    }
    /**
     * Set AntiPassbackZone value
     * @param int $antiPassbackZone
     * @return \App\Symmetry\Entities\StructType\XML_CurrentAntiPassbackForCardHolder
     */
    public function setAntiPassbackZone($antiPassbackZone = null)
    {
        // validation for constraint: int
        if (!is_null($antiPassbackZone) && !(is_int($antiPassbackZone) || ctype_digit($antiPassbackZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($antiPassbackZone, true), gettype($antiPassbackZone)), __LINE__);
        }
        $this->AntiPassbackZone = $antiPassbackZone;
        return $this;
    }
    /**
     * Get ReaderDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReaderDescription()
    {
        return isset($this->ReaderDescription) ? $this->ReaderDescription : null;
    }
    /**
     * Set ReaderDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $readerDescription
     * @return \App\Symmetry\Entities\StructType\XML_CurrentAntiPassbackForCardHolder
     */
    public function setReaderDescription($readerDescription = null)
    {
        // validation for constraint: string
        if (!is_null($readerDescription) && !is_string($readerDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readerDescription, true), gettype($readerDescription)), __LINE__);
        }
        if (is_null($readerDescription) || (is_array($readerDescription) && empty($readerDescription))) {
            unset($this->ReaderDescription);
        } else {
            $this->ReaderDescription = $readerDescription;
        }
        return $this;
    }
    /**
     * Get ReaderID value
     * @return int|null
     */
    public function getReaderID()
    {
        return $this->ReaderID;
    }
    /**
     * Set ReaderID value
     * @param int $readerID
     * @return \App\Symmetry\Entities\StructType\XML_CurrentAntiPassbackForCardHolder
     */
    public function setReaderID($readerID = null)
    {
        // validation for constraint: int
        if (!is_null($readerID) && !(is_int($readerID) || ctype_digit($readerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($readerID, true), gettype($readerID)), __LINE__);
        }
        $this->ReaderID = $readerID;
        return $this;
    }
}
