<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmDef StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmDef
 * @subpackage Structs
 */
class XML_AlarmDef extends AbstractStructBase
{
    /**
     * The AlarmCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmCode;
    /**
     * The AlarmDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlarmDescription;
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmID;
    /**
     * The AlarmMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmMode;
    /**
     * Constructor method for XML_AlarmDef
     * @uses XML_AlarmDef::setAlarmCode()
     * @uses XML_AlarmDef::setAlarmDescription()
     * @uses XML_AlarmDef::setAlarmID()
     * @uses XML_AlarmDef::setAlarmMode()
     * @param int $alarmCode
     * @param string $alarmDescription
     * @param int $alarmID
     * @param string $alarmMode
     */
    public function __construct($alarmCode = null, $alarmDescription = null, $alarmID = null, $alarmMode = null)
    {
        $this
            ->setAlarmCode($alarmCode)
            ->setAlarmDescription($alarmDescription)
            ->setAlarmID($alarmID)
            ->setAlarmMode($alarmMode);
    }
    /**
     * Get AlarmCode value
     * @return int|null
     */
    public function getAlarmCode()
    {
        return $this->AlarmCode;
    }
    /**
     * Set AlarmCode value
     * @param int $alarmCode
     * @return \App\Symmetry\Entities\StructType\XML_AlarmDef
     */
    public function setAlarmCode($alarmCode = null)
    {
        // validation for constraint: int
        if (!is_null($alarmCode) && !(is_int($alarmCode) || ctype_digit($alarmCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmCode, true), gettype($alarmCode)), __LINE__);
        }
        $this->AlarmCode = $alarmCode;
        return $this;
    }
    /**
     * Get AlarmDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlarmDescription()
    {
        return isset($this->AlarmDescription) ? $this->AlarmDescription : null;
    }
    /**
     * Set AlarmDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alarmDescription
     * @return \App\Symmetry\Entities\StructType\XML_AlarmDef
     */
    public function setAlarmDescription($alarmDescription = null)
    {
        // validation for constraint: string
        if (!is_null($alarmDescription) && !is_string($alarmDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alarmDescription, true), gettype($alarmDescription)), __LINE__);
        }
        if (is_null($alarmDescription) || (is_array($alarmDescription) && empty($alarmDescription))) {
            unset($this->AlarmDescription);
        } else {
            $this->AlarmDescription = $alarmDescription;
        }
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int|null
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmDef
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get AlarmMode value
     * @return string|null
     */
    public function getAlarmMode()
    {
        return $this->AlarmMode;
    }
    /**
     * Set AlarmMode value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmMode::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmMode
     * @return \App\Symmetry\Entities\StructType\XML_AlarmDef
     */
    public function setAlarmMode($alarmMode = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmMode::valueIsValid($alarmMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmMode', is_array($alarmMode) ? implode(', ', $alarmMode) : var_export($alarmMode, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmMode::getValidValues())), __LINE__);
        }
        $this->AlarmMode = $alarmMode;
        return $this;
    }
}
