<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmCommandLine StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmCommandLine
 * @subpackage Structs
 */
class XML_AlarmCommandLine extends AbstractStructBase
{
    /**
     * The AckDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AckDate;
    /**
     * The AckUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AckUserName;
    /**
     * The ActivityCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActivityCategory;
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmID;
    /**
     * The AlarmStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmStatus;
    /**
     * The Color
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Color;
    /**
     * The CommandLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandLine;
    /**
     * The CommandLineParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandLineParams;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Company;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The DeviceTypeEnumerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceTypeEnumerated;
    /**
     * The EventOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EventOnly;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Location;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Priority;
    /**
     * The What
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $What;
    /**
     * The When
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $When;
    /**
     * The Where
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Where;
    /**
     * The Who
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\StructType\Who
     */
    public $Who;
    /**
     * Constructor method for XML_AlarmCommandLine
     * @uses XML_AlarmCommandLine::setAckDate()
     * @uses XML_AlarmCommandLine::setAckUserName()
     * @uses XML_AlarmCommandLine::setActivityCategory()
     * @uses XML_AlarmCommandLine::setAlarmID()
     * @uses XML_AlarmCommandLine::setAlarmStatus()
     * @uses XML_AlarmCommandLine::setColor()
     * @uses XML_AlarmCommandLine::setCommandLine()
     * @uses XML_AlarmCommandLine::setCommandLineParams()
     * @uses XML_AlarmCommandLine::setCompany()
     * @uses XML_AlarmCommandLine::setCompanyID()
     * @uses XML_AlarmCommandLine::setDeviceTypeEnumerated()
     * @uses XML_AlarmCommandLine::setEventOnly()
     * @uses XML_AlarmCommandLine::setLocation()
     * @uses XML_AlarmCommandLine::setPriority()
     * @uses XML_AlarmCommandLine::setWhat()
     * @uses XML_AlarmCommandLine::setWhen()
     * @uses XML_AlarmCommandLine::setWhere()
     * @uses XML_AlarmCommandLine::setWho()
     * @param string $ackDate
     * @param string $ackUserName
     * @param string $activityCategory
     * @param int $alarmID
     * @param string $alarmStatus
     * @param int $color
     * @param string $commandLine
     * @param string $commandLineParams
     * @param string $company
     * @param int $companyID
     * @param string $deviceTypeEnumerated
     * @param bool $eventOnly
     * @param string $location
     * @param int $priority
     * @param string $what
     * @param string $when
     * @param string $where
     * @param \App\Symmetry\Entities\StructType\Who $who
     */
    public function __construct($ackDate = null, $ackUserName = null, $activityCategory = null, $alarmID = null, $alarmStatus = null, $color = null, $commandLine = null, $commandLineParams = null, $company = null, $companyID = null, $deviceTypeEnumerated = null, $eventOnly = null, $location = null, $priority = null, $what = null, $when = null, $where = null, \App\Symmetry\Entities\StructType\Who $who = null)
    {
        $this
            ->setAckDate($ackDate)
            ->setAckUserName($ackUserName)
            ->setActivityCategory($activityCategory)
            ->setAlarmID($alarmID)
            ->setAlarmStatus($alarmStatus)
            ->setColor($color)
            ->setCommandLine($commandLine)
            ->setCommandLineParams($commandLineParams)
            ->setCompany($company)
            ->setCompanyID($companyID)
            ->setDeviceTypeEnumerated($deviceTypeEnumerated)
            ->setEventOnly($eventOnly)
            ->setLocation($location)
            ->setPriority($priority)
            ->setWhat($what)
            ->setWhen($when)
            ->setWhere($where)
            ->setWho($who);
    }
    /**
     * Get AckDate value
     * @return string|null
     */
    public function getAckDate()
    {
        return $this->AckDate;
    }
    /**
     * Set AckDate value
     * @param string $ackDate
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setAckDate($ackDate = null)
    {
        // validation for constraint: string
        if (!is_null($ackDate) && !is_string($ackDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ackDate, true), gettype($ackDate)), __LINE__);
        }
        $this->AckDate = $ackDate;
        return $this;
    }
    /**
     * Get AckUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAckUserName()
    {
        return isset($this->AckUserName) ? $this->AckUserName : null;
    }
    /**
     * Set AckUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ackUserName
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setAckUserName($ackUserName = null)
    {
        // validation for constraint: string
        if (!is_null($ackUserName) && !is_string($ackUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ackUserName, true), gettype($ackUserName)), __LINE__);
        }
        if (is_null($ackUserName) || (is_array($ackUserName) && empty($ackUserName))) {
            unset($this->AckUserName);
        } else {
            $this->AckUserName = $ackUserName;
        }
        return $this;
    }
    /**
     * Get ActivityCategory value
     * @return string|null
     */
    public function getActivityCategory()
    {
        return $this->ActivityCategory;
    }
    /**
     * Set ActivityCategory value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityCategory
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setActivityCategory($activityCategory = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::valueIsValid($activityCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory', is_array($activityCategory) ? implode(', ', $activityCategory) : var_export($activityCategory, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmActivtityCategory::getValidValues())), __LINE__);
        }
        $this->ActivityCategory = $activityCategory;
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int|null
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
    /**
     * Get AlarmStatus value
     * @return string|null
     */
    public function getAlarmStatus()
    {
        return $this->AlarmStatus;
    }
    /**
     * Set AlarmStatus value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmStatus::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmStatus
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setAlarmStatus($alarmStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmStatus::valueIsValid($alarmStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmStatus', is_array($alarmStatus) ? implode(', ', $alarmStatus) : var_export($alarmStatus, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmStatus::getValidValues())), __LINE__);
        }
        $this->AlarmStatus = $alarmStatus;
        return $this;
    }
    /**
     * Get Color value
     * @return int|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param int $color
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setColor($color = null)
    {
        // validation for constraint: int
        if (!is_null($color) && !(is_int($color) || ctype_digit($color))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($color, true), gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get CommandLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandLine()
    {
        return isset($this->CommandLine) ? $this->CommandLine : null;
    }
    /**
     * Set CommandLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandLine
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setCommandLine($commandLine = null)
    {
        // validation for constraint: string
        if (!is_null($commandLine) && !is_string($commandLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandLine, true), gettype($commandLine)), __LINE__);
        }
        if (is_null($commandLine) || (is_array($commandLine) && empty($commandLine))) {
            unset($this->CommandLine);
        } else {
            $this->CommandLine = $commandLine;
        }
        return $this;
    }
    /**
     * Get CommandLineParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandLineParams()
    {
        return isset($this->CommandLineParams) ? $this->CommandLineParams : null;
    }
    /**
     * Set CommandLineParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandLineParams
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setCommandLineParams($commandLineParams = null)
    {
        // validation for constraint: string
        if (!is_null($commandLineParams) && !is_string($commandLineParams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandLineParams, true), gettype($commandLineParams)), __LINE__);
        }
        if (is_null($commandLineParams) || (is_array($commandLineParams) && empty($commandLineParams))) {
            unset($this->CommandLineParams);
        } else {
            $this->CommandLineParams = $commandLineParams;
        }
        return $this;
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $company
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get DeviceTypeEnumerated value
     * @return string|null
     */
    public function getDeviceTypeEnumerated()
    {
        return $this->DeviceTypeEnumerated;
    }
    /**
     * Set DeviceTypeEnumerated value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceTypeEnumerated
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setDeviceTypeEnumerated($deviceTypeEnumerated = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceTypeEnumerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceTypeEnumerated) ? implode(', ', $deviceTypeEnumerated) : var_export($deviceTypeEnumerated, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceTypeEnumerated = $deviceTypeEnumerated;
        return $this;
    }
    /**
     * Get EventOnly value
     * @return bool|null
     */
    public function getEventOnly()
    {
        return $this->EventOnly;
    }
    /**
     * Set EventOnly value
     * @param bool $eventOnly
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setEventOnly($eventOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($eventOnly) && !is_bool($eventOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eventOnly, true), gettype($eventOnly)), __LINE__);
        }
        $this->EventOnly = $eventOnly;
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $location
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get What value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhat()
    {
        return isset($this->What) ? $this->What : null;
    }
    /**
     * Set What value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $what
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setWhat($what = null)
    {
        // validation for constraint: string
        if (!is_null($what) && !is_string($what)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($what, true), gettype($what)), __LINE__);
        }
        if (is_null($what) || (is_array($what) && empty($what))) {
            unset($this->What);
        } else {
            $this->What = $what;
        }
        return $this;
    }
    /**
     * Get When value
     * @return string|null
     */
    public function getWhen()
    {
        return $this->When;
    }
    /**
     * Set When value
     * @param string $when
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setWhen($when = null)
    {
        // validation for constraint: string
        if (!is_null($when) && !is_string($when)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($when, true), gettype($when)), __LINE__);
        }
        $this->When = $when;
        return $this;
    }
    /**
     * Get Where value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhere()
    {
        return isset($this->Where) ? $this->Where : null;
    }
    /**
     * Set Where value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $where
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setWhere($where = null)
    {
        // validation for constraint: string
        if (!is_null($where) && !is_string($where)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($where, true), gettype($where)), __LINE__);
        }
        if (is_null($where) || (is_array($where) && empty($where))) {
            unset($this->Where);
        } else {
            $this->Where = $where;
        }
        return $this;
    }
    /**
     * Get Who value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\StructType\Who|null
     */
    public function getWho()
    {
        return isset($this->Who) ? $this->Who : null;
    }
    /**
     * Set Who value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\StructType\Who $who
     * @return \App\Symmetry\Entities\StructType\XML_AlarmCommandLine
     */
    public function setWho(\App\Symmetry\Entities\StructType\Who $who = null)
    {
        if (is_null($who) || (is_array($who) && empty($who))) {
            unset($this->Who);
        } else {
            $this->Who = $who;
        }
        return $this;
    }
}
