<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pagination StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Pagination
 * @subpackage Structs
 */
class Pagination extends AbstractStructBase
{
    /**
     * The Bookmark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bookmark;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PageSize;
    /**
     * The UsePagination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsePagination;
    /**
     * Constructor method for Pagination
     * @uses Pagination::setBookmark()
     * @uses Pagination::setPageSize()
     * @uses Pagination::setUsePagination()
     * @param string $bookmark
     * @param int $pageSize
     * @param bool $usePagination
     */
    public function __construct($bookmark = null, $pageSize = null, $usePagination = null)
    {
        $this
            ->setBookmark($bookmark)
            ->setPageSize($pageSize)
            ->setUsePagination($usePagination);
    }
    /**
     * Get Bookmark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookmark()
    {
        return isset($this->Bookmark) ? $this->Bookmark : null;
    }
    /**
     * Set Bookmark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookmark
     * @return \App\Symmetry\Entities\StructType\Pagination
     */
    public function setBookmark($bookmark = null)
    {
        // validation for constraint: string
        if (!is_null($bookmark) && !is_string($bookmark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookmark, true), gettype($bookmark)), __LINE__);
        }
        if (is_null($bookmark) || (is_array($bookmark) && empty($bookmark))) {
            unset($this->Bookmark);
        } else {
            $this->Bookmark = $bookmark;
        }
        return $this;
    }
    /**
     * Get PageSize value
     * @return int|null
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }
    /**
     * Set PageSize value
     * @param int $pageSize
     * @return \App\Symmetry\Entities\StructType\Pagination
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }
    /**
     * Get UsePagination value
     * @return bool|null
     */
    public function getUsePagination()
    {
        return $this->UsePagination;
    }
    /**
     * Set UsePagination value
     * @param bool $usePagination
     * @return \App\Symmetry\Entities\StructType\Pagination
     */
    public function setUsePagination($usePagination = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePagination) && !is_bool($usePagination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePagination, true), gettype($usePagination)), __LINE__);
        }
        $this->UsePagination = $usePagination;
        return $this;
    }
}
