<?php

namespace App\Symmetry\Entities\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for GTR ServiceType
 * @subpackage Services
 */
class GTR extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named G4TRename
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \App\Symmetry\Entities\StructType\G4TRename $parameters
     * @return \App\Symmetry\Entities\StructType\G4TRenameResponse|bool
     */
    public function G4TRename(\App\Symmetry\Entities\StructType\G4TRename $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->G4TRename($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \App\Symmetry\Entities\StructType\G4TRenameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
