<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Symmetry\Entities\ClassMap::get(),
);
/**
 * Samples for GTL ServiceType
 */
$gTL = new \App\Symmetry\Entities\ServiceType\GTL($options);
/**
 * Sample call for G4TLogin operation/method
 */
if ($gTL->G4TLogin(new \App\Symmetry\Entities\StructType\G4TLogin()) !== false) {
    print_r($gTL->getResult());
} else {
    print_r($gTL->getLastError());
}
/**
 * Samples for GTG ServiceType
 */
$gTG = new \App\Symmetry\Entities\ServiceType\GTG($options);
/**
 * Sample call for G4TGetSystemParameters operation/method
 */
if ($gTG->G4TGetSystemParameters(new \App\Symmetry\Entities\StructType\G4TGetSystemParameters()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetImportRecordRequests operation/method
 */
if ($gTG->G4TGetImportRecordRequests(new \App\Symmetry\Entities\StructType\G4TGetImportRecordRequests()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetImportCardHolderDataStatus operation/method
 */
if ($gTG->G4TGetImportCardHolderDataStatus(new \App\Symmetry\Entities\StructType\G4TGetImportCardHolderDataStatus()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetAccessGroups operation/method
 */
if ($gTG->G4TGetAccessGroups(new \App\Symmetry\Entities\StructType\G4TGetAccessGroups()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetTimeCodes operation/method
 */
if ($gTG->G4TGetTimeCodes(new \App\Symmetry\Entities\StructType\G4TGetTimeCodes()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetBadgeFormats operation/method
 */
if ($gTG->G4TGetBadgeFormats(new \App\Symmetry\Entities\StructType\G4TGetBadgeFormats()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetPersonalDataTitles operation/method
 */
if ($gTG->G4TGetPersonalDataTitles(new \App\Symmetry\Entities\StructType\G4TGetPersonalDataTitles()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetDeviceTypes operation/method
 */
if ($gTG->G4TGetDeviceTypes(new \App\Symmetry\Entities\StructType\G4TGetDeviceTypes()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetAdminTypes operation/method
 */
if ($gTG->G4TGetAdminTypes(new \App\Symmetry\Entities\StructType\G4TGetAdminTypes()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCompanies operation/method
 */
if ($gTG->G4TGetCompanies(new \App\Symmetry\Entities\StructType\G4TGetCompanies()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCommandTypes operation/method
 */
if ($gTG->G4TGetCommandTypes(new \App\Symmetry\Entities\StructType\G4TGetCommandTypes()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetOutstandingAlarms operation/method
 */
if ($gTG->G4TGetOutstandingAlarms(new \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarms()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetOutstandingAlarmsDocument operation/method
 */
if ($gTG->G4TGetOutstandingAlarmsDocument(new \App\Symmetry\Entities\StructType\G4TGetOutstandingAlarmsDocument()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCardHolderInformation operation/method
 */
if ($gTG->G4TGetCardHolderInformation(new \App\Symmetry\Entities\StructType\G4TGetCardHolderInformation()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCardHolderInformationDocument operation/method
 */
if ($gTG->G4TGetCardHolderInformationDocument(new \App\Symmetry\Entities\StructType\G4TGetCardHolderInformationDocument()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetDevices operation/method
 */
if ($gTG->G4TGetDevices(new \App\Symmetry\Entities\StructType\G4TGetDevices()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCommands operation/method
 */
if ($gTG->G4TGetCommands(new \App\Symmetry\Entities\StructType\G4TGetCommands()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetVersionInformation operation/method
 */
if ($gTG->G4TGetVersionInformation(new \App\Symmetry\Entities\StructType\G4TGetVersionInformation()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetDeviceAlarms operation/method
 */
if ($gTG->G4TGetDeviceAlarms(new \App\Symmetry\Entities\StructType\G4TGetDeviceAlarms()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetDeviceStatus operation/method
 */
if ($gTG->G4TGetDeviceStatus(new \App\Symmetry\Entities\StructType\G4TGetDeviceStatus()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetDoorStatus operation/method
 */
if ($gTG->G4TGetDoorStatus(new \App\Symmetry\Entities\StructType\G4TGetDoorStatus()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetAlarmActivityCategory operation/method
 */
if ($gTG->G4TGetAlarmActivityCategory(new \App\Symmetry\Entities\StructType\G4TGetAlarmActivityCategory()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetActivity operation/method
 */
if ($gTG->G4TGetActivity(new \App\Symmetry\Entities\StructType\G4TGetActivity()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetActivityDocument operation/method
 */
if ($gTG->G4TGetActivityDocument(new \App\Symmetry\Entities\StructType\G4TGetActivityDocument()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetLastReaderUsedForCardHolder operation/method
 */
if ($gTG->G4TGetLastReaderUsedForCardHolder(new \App\Symmetry\Entities\StructType\G4TGetLastReaderUsedForCardHolder()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetLastReadersUsedForCardHolder operation/method
 */
if ($gTG->G4TGetLastReadersUsedForCardHolder(new \App\Symmetry\Entities\StructType\G4TGetLastReadersUsedForCardHolder()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetLastCardTransactionsForAReader operation/method
 */
if ($gTG->G4TGetLastCardTransactionsForAReader(new \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReader()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetLastCardTransactionsForAReaderGroup operation/method
 */
if ($gTG->G4TGetLastCardTransactionsForAReaderGroup(new \App\Symmetry\Entities\StructType\G4TGetLastCardTransactionsForAReaderGroup()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Sample call for G4TGetCurrentAntiPassbackZone operation/method
 */
if ($gTG->G4TGetCurrentAntiPassbackZone(new \App\Symmetry\Entities\StructType\G4TGetCurrentAntiPassbackZone()) !== false) {
    print_r($gTG->getResult());
} else {
    print_r($gTG->getLastError());
}
/**
 * Samples for GTI ServiceType
 */
$gTI = new \App\Symmetry\Entities\ServiceType\GTI($options);
/**
 * Sample call for G4TImportCardHolderData operation/method
 */
if ($gTI->G4TImportCardHolderData(new \App\Symmetry\Entities\StructType\G4TImportCardHolderData()) !== false) {
    print_r($gTI->getResult());
} else {
    print_r($gTI->getLastError());
}
/**
 * Samples for GTC ServiceType
 */
$gTC = new \App\Symmetry\Entities\ServiceType\GTC($options);
/**
 * Sample call for G4TClearOutstandingAlarm operation/method
 */
if ($gTC->G4TClearOutstandingAlarm(new \App\Symmetry\Entities\StructType\G4TClearOutstandingAlarm()) !== false) {
    print_r($gTC->getResult());
} else {
    print_r($gTC->getLastError());
}
/**
 * Samples for GTA ServiceType
 */
$gTA = new \App\Symmetry\Entities\ServiceType\GTA($options);
/**
 * Sample call for G4TAddAlarms operation/method
 */
if ($gTA->G4TAddAlarms(new \App\Symmetry\Entities\StructType\G4TAddAlarms()) !== false) {
    print_r($gTA->getResult());
} else {
    print_r($gTA->getLastError());
}
/**
 * Sample call for G4TAddAlarmsWithCommandLine operation/method
 */
if ($gTA->G4TAddAlarmsWithCommandLine(new \App\Symmetry\Entities\StructType\G4TAddAlarmsWithCommandLine()) !== false) {
    print_r($gTA->getResult());
} else {
    print_r($gTA->getLastError());
}
/**
 * Sample call for G4TAddExtendedAlarms operation/method
 */
if ($gTA->G4TAddExtendedAlarms(new \App\Symmetry\Entities\StructType\G4TAddExtendedAlarms()) !== false) {
    print_r($gTA->getResult());
} else {
    print_r($gTA->getLastError());
}
/**
 * Samples for GTS ServiceType
 */
$gTS = new \App\Symmetry\Entities\ServiceType\GTS($options);
/**
 * Sample call for G4TSendDeviceCommand operation/method
 */
if ($gTS->G4TSendDeviceCommand(new \App\Symmetry\Entities\StructType\G4TSendDeviceCommand()) !== false) {
    print_r($gTS->getResult());
} else {
    print_r($gTS->getLastError());
}
/**
 * Sample call for G4TSetAlarmActivityCategory operation/method
 */
if ($gTS->G4TSetAlarmActivityCategory(new \App\Symmetry\Entities\StructType\G4TSetAlarmActivityCategory()) !== false) {
    print_r($gTS->getResult());
} else {
    print_r($gTS->getLastError());
}
/**
 * Sample call for G4TSendPCDoorControlAccessCommand operation/method
 */
if ($gTS->G4TSendPCDoorControlAccessCommand(new \App\Symmetry\Entities\StructType\G4TSendPCDoorControlAccessCommand()) !== false) {
    print_r($gTS->getResult());
} else {
    print_r($gTS->getLastError());
}
/**
 * Sample call for G4TSetCardHoldersAntipassbackZone operation/method
 */
if ($gTS->G4TSetCardHoldersAntipassbackZone(new \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackZone()) !== false) {
    print_r($gTS->getResult());
} else {
    print_r($gTS->getLastError());
}
/**
 * Sample call for G4TSetCardHoldersAntipassbackToNeutral operation/method
 */
if ($gTS->G4TSetCardHoldersAntipassbackToNeutral(new \App\Symmetry\Entities\StructType\G4TSetCardHoldersAntipassbackToNeutral()) !== false) {
    print_r($gTS->getResult());
} else {
    print_r($gTS->getLastError());
}
/**
 * Samples for GTE ServiceType
 */
$gTE = new \App\Symmetry\Entities\ServiceType\GTE($options);
/**
 * Sample call for G4TEditReaderGroup operation/method
 */
if ($gTE->G4TEditReaderGroup(new \App\Symmetry\Entities\StructType\G4TEditReaderGroup()) !== false) {
    print_r($gTE->getResult());
} else {
    print_r($gTE->getLastError());
}
/**
 * Sample call for G4TEditFloorGroup operation/method
 */
if ($gTE->G4TEditFloorGroup(new \App\Symmetry\Entities\StructType\G4TEditFloorGroup()) !== false) {
    print_r($gTE->getResult());
} else {
    print_r($gTE->getLastError());
}
/**
 * Sample call for G4TEditAccessCode operation/method
 */
if ($gTE->G4TEditAccessCode(new \App\Symmetry\Entities\StructType\G4TEditAccessCode()) !== false) {
    print_r($gTE->getResult());
} else {
    print_r($gTE->getLastError());
}
/**
 * Samples for GTR ServiceType
 */
$gTR = new \App\Symmetry\Entities\ServiceType\GTR($options);
/**
 * Sample call for G4TRename operation/method
 */
if ($gTR->G4TRename(new \App\Symmetry\Entities\StructType\G4TRename()) !== false) {
    print_r($gTR->getResult());
} else {
    print_r($gTR->getLastError());
}
/**
 * Samples for GTV ServiceType
 */
$gTV = new \App\Symmetry\Entities\ServiceType\GTV($options);
/**
 * Sample call for G4TVerifyLicense operation/method
 */
if ($gTV->G4TVerifyLicense(new \App\Symmetry\Entities\StructType\G4TVerifyLicense()) !== false) {
    print_r($gTV->getResult());
} else {
    print_r($gTV->getLastError());
}
