<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Status StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Status
 * @subpackage Structs
 */
class XML_Status extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusDescription;
    /**
     * The StatusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StatusID;
    /**
     * Constructor method for XML_Status
     * @uses XML_Status::setStatusCode()
     * @uses XML_Status::setStatusDescription()
     * @uses XML_Status::setStatusID()
     * @param string $statusCode
     * @param string $statusDescription
     * @param int $statusID
     */
    public function __construct($statusCode = null, $statusDescription = null, $statusID = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusDescription($statusDescription)
            ->setStatusID($statusID);
    }
    /**
     * Get StatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusCode()
    {
        return isset($this->StatusCode) ? $this->StatusCode : null;
    }
    /**
     * Set StatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusCode
     * @return \App\Symmetry\Entities\StructType\XML_Status
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        if (is_null($statusCode) || (is_array($statusCode) && empty($statusCode))) {
            unset($this->StatusCode);
        } else {
            $this->StatusCode = $statusCode;
        }
        return $this;
    }
    /**
     * Get StatusDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusDescription()
    {
        return isset($this->StatusDescription) ? $this->StatusDescription : null;
    }
    /**
     * Set StatusDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusDescription
     * @return \App\Symmetry\Entities\StructType\XML_Status
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDescription, true), gettype($statusDescription)), __LINE__);
        }
        if (is_null($statusDescription) || (is_array($statusDescription) && empty($statusDescription))) {
            unset($this->StatusDescription);
        } else {
            $this->StatusDescription = $statusDescription;
        }
        return $this;
    }
    /**
     * Get StatusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->StatusID;
    }
    /**
     * Set StatusID value
     * @param int $statusID
     * @return \App\Symmetry\Entities\StructType\XML_Status
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->StatusID = $statusID;
        return $this;
    }
}
