<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_PCDoorControlRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_PCDoorControlRequest
 * @subpackage Structs
 */
class XML_PCDoorControlRequest extends AbstractStructBase
{
    /**
     * The CardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardHolderID;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardNumber;
    /**
     * The DeviceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceNumber;
    /**
     * The DoorControlAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DoorControlAction;
    /**
     * The DoorControlUnitID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DoorControlUnitID;
    /**
     * The NodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NodeID;
    /**
     * Constructor method for XML_PCDoorControlRequest
     * @uses XML_PCDoorControlRequest::setCardHolderID()
     * @uses XML_PCDoorControlRequest::setCardNumber()
     * @uses XML_PCDoorControlRequest::setDeviceNumber()
     * @uses XML_PCDoorControlRequest::setDoorControlAction()
     * @uses XML_PCDoorControlRequest::setDoorControlUnitID()
     * @uses XML_PCDoorControlRequest::setNodeID()
     * @param int $cardHolderID
     * @param int $cardNumber
     * @param int $deviceNumber
     * @param string $doorControlAction
     * @param int $doorControlUnitID
     * @param int $nodeID
     */
    public function __construct($cardHolderID = null, $cardNumber = null, $deviceNumber = null, $doorControlAction = null, $doorControlUnitID = null, $nodeID = null)
    {
        $this
            ->setCardHolderID($cardHolderID)
            ->setCardNumber($cardNumber)
            ->setDeviceNumber($deviceNumber)
            ->setDoorControlAction($doorControlAction)
            ->setDoorControlUnitID($doorControlUnitID)
            ->setNodeID($nodeID);
    }
    /**
     * Get CardHolderID value
     * @return int|null
     */
    public function getCardHolderID()
    {
        return $this->CardHolderID;
    }
    /**
     * Set CardHolderID value
     * @param int $cardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setCardHolderID($cardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($cardHolderID) && !(is_int($cardHolderID) || ctype_digit($cardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardHolderID, true), gettype($cardHolderID)), __LINE__);
        }
        $this->CardHolderID = $cardHolderID;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param int $cardNumber
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !(is_int($cardNumber) || ctype_digit($cardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get DeviceNumber value
     * @return int|null
     */
    public function getDeviceNumber()
    {
        return $this->DeviceNumber;
    }
    /**
     * Set DeviceNumber value
     * @param int $deviceNumber
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setDeviceNumber($deviceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($deviceNumber) && !(is_int($deviceNumber) || ctype_digit($deviceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceNumber, true), gettype($deviceNumber)), __LINE__);
        }
        $this->DeviceNumber = $deviceNumber;
        return $this;
    }
    /**
     * Get DoorControlAction value
     * @return string|null
     */
    public function getDoorControlAction()
    {
        return $this->DoorControlAction;
    }
    /**
     * Set DoorControlAction value
     * @uses \App\Symmetry\Entities\EnumType\EnPCDoorControlAction::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnPCDoorControlAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $doorControlAction
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setDoorControlAction($doorControlAction = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnPCDoorControlAction::valueIsValid($doorControlAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnPCDoorControlAction', is_array($doorControlAction) ? implode(', ', $doorControlAction) : var_export($doorControlAction, true), implode(', ', \App\Symmetry\Entities\EnumType\EnPCDoorControlAction::getValidValues())), __LINE__);
        }
        $this->DoorControlAction = $doorControlAction;
        return $this;
    }
    /**
     * Get DoorControlUnitID value
     * @return int|null
     */
    public function getDoorControlUnitID()
    {
        return $this->DoorControlUnitID;
    }
    /**
     * Set DoorControlUnitID value
     * @param int $doorControlUnitID
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setDoorControlUnitID($doorControlUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($doorControlUnitID) && !(is_int($doorControlUnitID) || ctype_digit($doorControlUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($doorControlUnitID, true), gettype($doorControlUnitID)), __LINE__);
        }
        $this->DoorControlUnitID = $doorControlUnitID;
        return $this;
    }
    /**
     * Get NodeID value
     * @return int|null
     */
    public function getNodeID()
    {
        return $this->NodeID;
    }
    /**
     * Set NodeID value
     * @param int $nodeID
     * @return \App\Symmetry\Entities\StructType\XML_PCDoorControlRequest
     */
    public function setNodeID($nodeID = null)
    {
        // validation for constraint: int
        if (!is_null($nodeID) && !(is_int($nodeID) || ctype_digit($nodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nodeID, true), gettype($nodeID)), __LINE__);
        }
        $this->NodeID = $nodeID;
        return $this;
    }
}
