<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_LastReadersUsedForCardHolderRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_LastReadersUsedForCardHolderRequest
 * @subpackage Structs
 */
class XML_LastReadersUsedForCardHolderRequest extends AbstractStructBase
{
    /**
     * The CardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardHolderID;
    /**
     * The NumberOfTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTransactions;
    /**
     * Constructor method for XML_LastReadersUsedForCardHolderRequest
     * @uses XML_LastReadersUsedForCardHolderRequest::setCardHolderID()
     * @uses XML_LastReadersUsedForCardHolderRequest::setNumberOfTransactions()
     * @param int $cardHolderID
     * @param int $numberOfTransactions
     */
    public function __construct($cardHolderID = null, $numberOfTransactions = null)
    {
        $this
            ->setCardHolderID($cardHolderID)
            ->setNumberOfTransactions($numberOfTransactions);
    }
    /**
     * Get CardHolderID value
     * @return int|null
     */
    public function getCardHolderID()
    {
        return $this->CardHolderID;
    }
    /**
     * Set CardHolderID value
     * @param int $cardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_LastReadersUsedForCardHolderRequest
     */
    public function setCardHolderID($cardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($cardHolderID) && !(is_int($cardHolderID) || ctype_digit($cardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardHolderID, true), gettype($cardHolderID)), __LINE__);
        }
        $this->CardHolderID = $cardHolderID;
        return $this;
    }
    /**
     * Get NumberOfTransactions value
     * @return int|null
     */
    public function getNumberOfTransactions()
    {
        return $this->NumberOfTransactions;
    }
    /**
     * Set NumberOfTransactions value
     * @param int $numberOfTransactions
     * @return \App\Symmetry\Entities\StructType\XML_LastReadersUsedForCardHolderRequest
     */
    public function setNumberOfTransactions($numberOfTransactions = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTransactions) && !(is_int($numberOfTransactions) || ctype_digit($numberOfTransactions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTransactions, true), gettype($numberOfTransactions)), __LINE__);
        }
        $this->NumberOfTransactions = $numberOfTransactions;
        return $this;
    }
}
