<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_ImportDataCardHolderStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_ImportDataCardHolderStatus
 * @subpackage Structs
 */
class XML_ImportDataCardHolderStatus extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The EmployeeReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmployeeReference;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The ImportRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImportRequest;
    /**
     * The ImportResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImportResult;
    /**
     * The ImportResultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImportResultDescription;
    /**
     * The InitLet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InitLet;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for XML_ImportDataCardHolderStatus
     * @uses XML_ImportDataCardHolderStatus::setCompanyID()
     * @uses XML_ImportDataCardHolderStatus::setEmployeeReference()
     * @uses XML_ImportDataCardHolderStatus::setFirstName()
     * @uses XML_ImportDataCardHolderStatus::setImportRequest()
     * @uses XML_ImportDataCardHolderStatus::setImportResult()
     * @uses XML_ImportDataCardHolderStatus::setImportResultDescription()
     * @uses XML_ImportDataCardHolderStatus::setInitLet()
     * @uses XML_ImportDataCardHolderStatus::setLastName()
     * @param int $companyID
     * @param string $employeeReference
     * @param string $firstName
     * @param string $importRequest
     * @param string $importResult
     * @param string $importResultDescription
     * @param string $initLet
     * @param string $lastName
     */
    public function __construct($companyID = null, $employeeReference = null, $firstName = null, $importRequest = null, $importResult = null, $importResultDescription = null, $initLet = null, $lastName = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setEmployeeReference($employeeReference)
            ->setFirstName($firstName)
            ->setImportRequest($importRequest)
            ->setImportResult($importResult)
            ->setImportResultDescription($importResultDescription)
            ->setInitLet($initLet)
            ->setLastName($lastName);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EmployeeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmployeeReference()
    {
        return isset($this->EmployeeReference) ? $this->EmployeeReference : null;
    }
    /**
     * Set EmployeeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $employeeReference
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setEmployeeReference($employeeReference = null)
    {
        // validation for constraint: string
        if (!is_null($employeeReference) && !is_string($employeeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeReference, true), gettype($employeeReference)), __LINE__);
        }
        if (is_null($employeeReference) || (is_array($employeeReference) && empty($employeeReference))) {
            unset($this->EmployeeReference);
        } else {
            $this->EmployeeReference = $employeeReference;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get ImportRequest value
     * @return string|null
     */
    public function getImportRequest()
    {
        return $this->ImportRequest;
    }
    /**
     * Set ImportRequest value
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordRequest::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordRequest::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importRequest
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setImportRequest($importRequest = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnImportRecordRequest::valueIsValid($importRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnImportRecordRequest', is_array($importRequest) ? implode(', ', $importRequest) : var_export($importRequest, true), implode(', ', \App\Symmetry\Entities\EnumType\EnImportRecordRequest::getValidValues())), __LINE__);
        }
        $this->ImportRequest = $importRequest;
        return $this;
    }
    /**
     * Get ImportResult value
     * @return string|null
     */
    public function getImportResult()
    {
        return $this->ImportResult;
    }
    /**
     * Set ImportResult value
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordResult::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnImportRecordResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $importResult
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setImportResult($importResult = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnImportRecordResult::valueIsValid($importResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnImportRecordResult', is_array($importResult) ? implode(', ', $importResult) : var_export($importResult, true), implode(', ', \App\Symmetry\Entities\EnumType\EnImportRecordResult::getValidValues())), __LINE__);
        }
        $this->ImportResult = $importResult;
        return $this;
    }
    /**
     * Get ImportResultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportResultDescription()
    {
        return isset($this->ImportResultDescription) ? $this->ImportResultDescription : null;
    }
    /**
     * Set ImportResultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importResultDescription
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setImportResultDescription($importResultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($importResultDescription) && !is_string($importResultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importResultDescription, true), gettype($importResultDescription)), __LINE__);
        }
        if (is_null($importResultDescription) || (is_array($importResultDescription) && empty($importResultDescription))) {
            unset($this->ImportResultDescription);
        } else {
            $this->ImportResultDescription = $importResultDescription;
        }
        return $this;
    }
    /**
     * Get InitLet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitLet()
    {
        return isset($this->InitLet) ? $this->InitLet : null;
    }
    /**
     * Set InitLet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initLet
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setInitLet($initLet = null)
    {
        // validation for constraint: string
        if (!is_null($initLet) && !is_string($initLet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initLet, true), gettype($initLet)), __LINE__);
        }
        if (is_null($initLet) || (is_array($initLet) && empty($initLet))) {
            unset($this->InitLet);
        } else {
            $this->InitLet = $initLet;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \App\Symmetry\Entities\StructType\XML_ImportDataCardHolderStatus
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
}
