<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditFloorGroupDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditFloorGroupDocument
 * @subpackage Structs
 */
class XML_EditFloorGroupDocument extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The EditModeEnumerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EditModeEnumerated;
    /**
     * The FloorGroupID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FloorGroupID;
    /**
     * The FloorGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FloorGroupName;
    /**
     * The Floors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor
     */
    public $Floors;
    /**
     * Constructor method for XML_EditFloorGroupDocument
     * @uses XML_EditFloorGroupDocument::setCompanyID()
     * @uses XML_EditFloorGroupDocument::setEditModeEnumerated()
     * @uses XML_EditFloorGroupDocument::setFloorGroupID()
     * @uses XML_EditFloorGroupDocument::setFloorGroupName()
     * @uses XML_EditFloorGroupDocument::setFloors()
     * @param int $companyID
     * @param string $editModeEnumerated
     * @param int $floorGroupID
     * @param string $floorGroupName
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor $floors
     */
    public function __construct($companyID = null, $editModeEnumerated = null, $floorGroupID = null, $floorGroupName = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor $floors = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setEditModeEnumerated($editModeEnumerated)
            ->setFloorGroupID($floorGroupID)
            ->setFloorGroupName($floorGroupName)
            ->setFloors($floors);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroupDocument
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EditModeEnumerated value
     * @return string|null
     */
    public function getEditModeEnumerated()
    {
        return $this->EditModeEnumerated;
    }
    /**
     * Set EditModeEnumerated value
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editModeEnumerated
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroupDocument
     */
    public function setEditModeEnumerated($editModeEnumerated = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid($editModeEnumerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnEditMode', is_array($editModeEnumerated) ? implode(', ', $editModeEnumerated) : var_export($editModeEnumerated, true), implode(', ', \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues())), __LINE__);
        }
        $this->EditModeEnumerated = $editModeEnumerated;
        return $this;
    }
    /**
     * Get FloorGroupID value
     * @return int|null
     */
    public function getFloorGroupID()
    {
        return $this->FloorGroupID;
    }
    /**
     * Set FloorGroupID value
     * @param int $floorGroupID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroupDocument
     */
    public function setFloorGroupID($floorGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($floorGroupID) && !(is_int($floorGroupID) || ctype_digit($floorGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floorGroupID, true), gettype($floorGroupID)), __LINE__);
        }
        $this->FloorGroupID = $floorGroupID;
        return $this;
    }
    /**
     * Get FloorGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFloorGroupName()
    {
        return isset($this->FloorGroupName) ? $this->FloorGroupName : null;
    }
    /**
     * Set FloorGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $floorGroupName
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroupDocument
     */
    public function setFloorGroupName($floorGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($floorGroupName) && !is_string($floorGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($floorGroupName, true), gettype($floorGroupName)), __LINE__);
        }
        if (is_null($floorGroupName) || (is_array($floorGroupName) && empty($floorGroupName))) {
            unset($this->FloorGroupName);
        } else {
            $this->FloorGroupName = $floorGroupName;
        }
        return $this;
    }
    /**
     * Get Floors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor|null
     */
    public function getFloors()
    {
        return isset($this->Floors) ? $this->Floors : null;
    }
    /**
     * Set Floors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor $floors
     * @return \App\Symmetry\Entities\StructType\XML_EditFloorGroupDocument
     */
    public function setFloors(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloor $floors = null)
    {
        if (is_null($floors) || (is_array($floors) && empty($floors))) {
            unset($this->Floors);
        } else {
            $this->Floors = $floors;
        }
        return $this;
    }
}
