<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditFloor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditFloor
 * @subpackage Structs
 */
class XML_EditFloor extends AbstractStructBase
{
    /**
     * The ElevatorReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ElevatorReaderID;
    /**
     * The FloorID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FloorID;
    /**
     * Constructor method for XML_EditFloor
     * @uses XML_EditFloor::setElevatorReaderID()
     * @uses XML_EditFloor::setFloorID()
     * @param int $elevatorReaderID
     * @param int $floorID
     */
    public function __construct($elevatorReaderID = null, $floorID = null)
    {
        $this
            ->setElevatorReaderID($elevatorReaderID)
            ->setFloorID($floorID);
    }
    /**
     * Get ElevatorReaderID value
     * @return int|null
     */
    public function getElevatorReaderID()
    {
        return $this->ElevatorReaderID;
    }
    /**
     * Set ElevatorReaderID value
     * @param int $elevatorReaderID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloor
     */
    public function setElevatorReaderID($elevatorReaderID = null)
    {
        // validation for constraint: int
        if (!is_null($elevatorReaderID) && !(is_int($elevatorReaderID) || ctype_digit($elevatorReaderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elevatorReaderID, true), gettype($elevatorReaderID)), __LINE__);
        }
        $this->ElevatorReaderID = $elevatorReaderID;
        return $this;
    }
    /**
     * Get FloorID value
     * @return int|null
     */
    public function getFloorID()
    {
        return $this->FloorID;
    }
    /**
     * Set FloorID value
     * @param int $floorID
     * @return \App\Symmetry\Entities\StructType\XML_EditFloor
     */
    public function setFloorID($floorID = null)
    {
        // validation for constraint: int
        if (!is_null($floorID) && !(is_int($floorID) || ctype_digit($floorID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($floorID, true), gettype($floorID)), __LINE__);
        }
        $this->FloorID = $floorID;
        return $this;
    }
}
