<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_EditAccessCodeDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_EditAccessCodeDocument
 * @subpackage Structs
 */
class XML_EditAccessCodeDocument extends AbstractStructBase
{
    /**
     * The AccessCodeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AccessCodeID;
    /**
     * The AccessCodeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCodeName;
    /**
     * The Areas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea
     */
    public $Areas;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The EditModeEnumerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EditModeEnumerated;
    /**
     * The FloorGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup
     */
    public $FloorGroups;
    /**
     * The ReaderGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup
     */
    public $ReaderGroups;
    /**
     * The Readers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader
     */
    public $Readers;
    /**
     * Constructor method for XML_EditAccessCodeDocument
     * @uses XML_EditAccessCodeDocument::setAccessCodeID()
     * @uses XML_EditAccessCodeDocument::setAccessCodeName()
     * @uses XML_EditAccessCodeDocument::setAreas()
     * @uses XML_EditAccessCodeDocument::setCompanyID()
     * @uses XML_EditAccessCodeDocument::setEditModeEnumerated()
     * @uses XML_EditAccessCodeDocument::setFloorGroups()
     * @uses XML_EditAccessCodeDocument::setReaderGroups()
     * @uses XML_EditAccessCodeDocument::setReaders()
     * @param int $accessCodeID
     * @param string $accessCodeName
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea $areas
     * @param int $companyID
     * @param string $editModeEnumerated
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup $floorGroups
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup $readerGroups
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers
     */
    public function __construct($accessCodeID = null, $accessCodeName = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea $areas = null, $companyID = null, $editModeEnumerated = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup $floorGroups = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup $readerGroups = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers = null)
    {
        $this
            ->setAccessCodeID($accessCodeID)
            ->setAccessCodeName($accessCodeName)
            ->setAreas($areas)
            ->setCompanyID($companyID)
            ->setEditModeEnumerated($editModeEnumerated)
            ->setFloorGroups($floorGroups)
            ->setReaderGroups($readerGroups)
            ->setReaders($readers);
    }
    /**
     * Get AccessCodeID value
     * @return int|null
     */
    public function getAccessCodeID()
    {
        return $this->AccessCodeID;
    }
    /**
     * Set AccessCodeID value
     * @param int $accessCodeID
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setAccessCodeID($accessCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($accessCodeID) && !(is_int($accessCodeID) || ctype_digit($accessCodeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accessCodeID, true), gettype($accessCodeID)), __LINE__);
        }
        $this->AccessCodeID = $accessCodeID;
        return $this;
    }
    /**
     * Get AccessCodeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeName()
    {
        return isset($this->AccessCodeName) ? $this->AccessCodeName : null;
    }
    /**
     * Set AccessCodeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeName
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setAccessCodeName($accessCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeName) && !is_string($accessCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeName, true), gettype($accessCodeName)), __LINE__);
        }
        if (is_null($accessCodeName) || (is_array($accessCodeName) && empty($accessCodeName))) {
            unset($this->AccessCodeName);
        } else {
            $this->AccessCodeName = $accessCodeName;
        }
        return $this;
    }
    /**
     * Get Areas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea|null
     */
    public function getAreas()
    {
        return isset($this->Areas) ? $this->Areas : null;
    }
    /**
     * Set Areas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea $areas
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setAreas(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditArea $areas = null)
    {
        if (is_null($areas) || (is_array($areas) && empty($areas))) {
            unset($this->Areas);
        } else {
            $this->Areas = $areas;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EditModeEnumerated value
     * @return string|null
     */
    public function getEditModeEnumerated()
    {
        return $this->EditModeEnumerated;
    }
    /**
     * Set EditModeEnumerated value
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $editModeEnumerated
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setEditModeEnumerated($editModeEnumerated = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnEditMode::valueIsValid($editModeEnumerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnEditMode', is_array($editModeEnumerated) ? implode(', ', $editModeEnumerated) : var_export($editModeEnumerated, true), implode(', ', \App\Symmetry\Entities\EnumType\EnEditMode::getValidValues())), __LINE__);
        }
        $this->EditModeEnumerated = $editModeEnumerated;
        return $this;
    }
    /**
     * Get FloorGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup|null
     */
    public function getFloorGroups()
    {
        return isset($this->FloorGroups) ? $this->FloorGroups : null;
    }
    /**
     * Set FloorGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup $floorGroups
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setFloorGroups(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditFloorGroup $floorGroups = null)
    {
        if (is_null($floorGroups) || (is_array($floorGroups) && empty($floorGroups))) {
            unset($this->FloorGroups);
        } else {
            $this->FloorGroups = $floorGroups;
        }
        return $this;
    }
    /**
     * Get ReaderGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup|null
     */
    public function getReaderGroups()
    {
        return isset($this->ReaderGroups) ? $this->ReaderGroups : null;
    }
    /**
     * Set ReaderGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup $readerGroups
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setReaderGroups(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReaderGroup $readerGroups = null)
    {
        if (is_null($readerGroups) || (is_array($readerGroups) && empty($readerGroups))) {
            unset($this->ReaderGroups);
        } else {
            $this->ReaderGroups = $readerGroups;
        }
        return $this;
    }
    /**
     * Get Readers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader|null
     */
    public function getReaders()
    {
        return isset($this->Readers) ? $this->Readers : null;
    }
    /**
     * Set Readers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers
     * @return \App\Symmetry\Entities\StructType\XML_EditAccessCodeDocument
     */
    public function setReaders(\App\Symmetry\Entities\ArrayType\ArrayOfXML_EditReader $readers = null)
    {
        if (is_null($readers) || (is_array($readers) && empty($readers))) {
            unset($this->Readers);
        } else {
            $this->Readers = $readers;
        }
        return $this;
    }
}
