<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_Device StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_Device
 * @subpackage Structs
 */
class XML_Device extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The DeviceDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceDescription;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeviceID;
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DeviceType;
    /**
     * The ElevatorReaderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ElevatorReaderID;
    /**
     * Constructor method for XML_Device
     * @uses XML_Device::setCompanyID()
     * @uses XML_Device::setDeviceDescription()
     * @uses XML_Device::setDeviceID()
     * @uses XML_Device::setDeviceType()
     * @uses XML_Device::setElevatorReaderID()
     * @param int $companyID
     * @param string $deviceDescription
     * @param int $deviceID
     * @param string $deviceType
     * @param int $elevatorReaderID
     */
    public function __construct($companyID = null, $deviceDescription = null, $deviceID = null, $deviceType = null, $elevatorReaderID = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setDeviceDescription($deviceDescription)
            ->setDeviceID($deviceID)
            ->setDeviceType($deviceType)
            ->setElevatorReaderID($elevatorReaderID);
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_Device
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get DeviceDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceDescription()
    {
        return isset($this->DeviceDescription) ? $this->DeviceDescription : null;
    }
    /**
     * Set DeviceDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceDescription
     * @return \App\Symmetry\Entities\StructType\XML_Device
     */
    public function setDeviceDescription($deviceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDescription) && !is_string($deviceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDescription, true), gettype($deviceDescription)), __LINE__);
        }
        if (is_null($deviceDescription) || (is_array($deviceDescription) && empty($deviceDescription))) {
            unset($this->DeviceDescription);
        } else {
            $this->DeviceDescription = $deviceDescription;
        }
        return $this;
    }
    /**
     * Get DeviceID value
     * @return int|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param int $deviceID
     * @return \App\Symmetry\Entities\StructType\XML_Device
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: int
        if (!is_null($deviceID) && !(is_int($deviceID) || ctype_digit($deviceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \App\Symmetry\Entities\StructType\XML_Device
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnDeviceTypes::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnDeviceTypes', is_array($deviceType) ? implode(', ', $deviceType) : var_export($deviceType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnDeviceTypes::getValidValues())), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get ElevatorReaderID value
     * @return int|null
     */
    public function getElevatorReaderID()
    {
        return $this->ElevatorReaderID;
    }
    /**
     * Set ElevatorReaderID value
     * @param int $elevatorReaderID
     * @return \App\Symmetry\Entities\StructType\XML_Device
     */
    public function setElevatorReaderID($elevatorReaderID = null)
    {
        // validation for constraint: int
        if (!is_null($elevatorReaderID) && !(is_int($elevatorReaderID) || ctype_digit($elevatorReaderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($elevatorReaderID, true), gettype($elevatorReaderID)), __LINE__);
        }
        $this->ElevatorReaderID = $elevatorReaderID;
        return $this;
    }
}
