<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CommandType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CommandType
 * @subpackage Structs
 */
class XML_CommandType extends AbstractStructBase
{
    /**
     * The CommandDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandDescription;
    /**
     * The CommandType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommandType;
    /**
     * Constructor method for XML_CommandType
     * @uses XML_CommandType::setCommandDescription()
     * @uses XML_CommandType::setCommandType()
     * @param string $commandDescription
     * @param string $commandType
     */
    public function __construct($commandDescription = null, $commandType = null)
    {
        $this
            ->setCommandDescription($commandDescription)
            ->setCommandType($commandType);
    }
    /**
     * Get CommandDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandDescription()
    {
        return isset($this->CommandDescription) ? $this->CommandDescription : null;
    }
    /**
     * Set CommandDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandDescription
     * @return \App\Symmetry\Entities\StructType\XML_CommandType
     */
    public function setCommandDescription($commandDescription = null)
    {
        // validation for constraint: string
        if (!is_null($commandDescription) && !is_string($commandDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commandDescription, true), gettype($commandDescription)), __LINE__);
        }
        if (is_null($commandDescription) || (is_array($commandDescription) && empty($commandDescription))) {
            unset($this->CommandDescription);
        } else {
            $this->CommandDescription = $commandDescription;
        }
        return $this;
    }
    /**
     * Get CommandType value
     * @return string|null
     */
    public function getCommandType()
    {
        return $this->CommandType;
    }
    /**
     * Set CommandType value
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commandType
     * @return \App\Symmetry\Entities\StructType\XML_CommandType
     */
    public function setCommandType($commandType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnCommandType::valueIsValid($commandType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnCommandType', is_array($commandType) ? implode(', ', $commandType) : var_export($commandType, true), implode(', ', \App\Symmetry\Entities\EnumType\EnCommandType::getValidValues())), __LINE__);
        }
        $this->CommandType = $commandType;
        return $this;
    }
}
