<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardInfo
 * @subpackage Structs
 */
class XML_CardInfo extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The ActiveDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActiveDate;
    /**
     * The AgencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AgencyCode;
    /**
     * The BadgeFormatID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BadgeFormatID;
    /**
     * The CardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardID;
    /**
     * The CardIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardIdentifier;
    /**
     * The CardIssueLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardIssueLevel;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardNumber;
    /**
     * The CardNumberString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberString;
    /**
     * The CredentialSeriesCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CredentialSeriesCode;
    /**
     * The CustomerCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerCode;
    /**
     * The Encryption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Encryption;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The ExtendedPIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtendedPIN;
    /**
     * The IDSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDSCode;
    /**
     * The InactiveComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InactiveComment;
    /**
     * The OrganisationAssociation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationAssociation;
    /**
     * The OrganisationCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationCategory;
    /**
     * The OrganisationIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrganisationIdentifier;
    /**
     * The PIN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PIN;
    /**
     * The SystemCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SystemCode;
    /**
     * The UnitIDCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UnitIDCode;
    /**
     * Constructor method for XML_CardInfo
     * @uses XML_CardInfo::setActive()
     * @uses XML_CardInfo::setActiveDate()
     * @uses XML_CardInfo::setAgencyCode()
     * @uses XML_CardInfo::setBadgeFormatID()
     * @uses XML_CardInfo::setCardID()
     * @uses XML_CardInfo::setCardIdentifier()
     * @uses XML_CardInfo::setCardIssueLevel()
     * @uses XML_CardInfo::setCardNumber()
     * @uses XML_CardInfo::setCardNumberString()
     * @uses XML_CardInfo::setCredentialSeriesCode()
     * @uses XML_CardInfo::setCustomerCode()
     * @uses XML_CardInfo::setEncryption()
     * @uses XML_CardInfo::setExpiryDate()
     * @uses XML_CardInfo::setExtendedPIN()
     * @uses XML_CardInfo::setIDSCode()
     * @uses XML_CardInfo::setInactiveComment()
     * @uses XML_CardInfo::setOrganisationAssociation()
     * @uses XML_CardInfo::setOrganisationCategory()
     * @uses XML_CardInfo::setOrganisationIdentifier()
     * @uses XML_CardInfo::setPIN()
     * @uses XML_CardInfo::setSystemCode()
     * @uses XML_CardInfo::setUnitIDCode()
     * @param bool $active
     * @param string $activeDate
     * @param int $agencyCode
     * @param int $badgeFormatID
     * @param int $cardID
     * @param string $cardIdentifier
     * @param string $cardIssueLevel
     * @param int $cardNumber
     * @param string $cardNumberString
     * @param int $credentialSeriesCode
     * @param int $customerCode
     * @param int $encryption
     * @param string $expiryDate
     * @param string $extendedPIN
     * @param string $iDSCode
     * @param string $inactiveComment
     * @param int $organisationAssociation
     * @param int $organisationCategory
     * @param int $organisationIdentifier
     * @param int $pIN
     * @param int $systemCode
     * @param int $unitIDCode
     */
    public function __construct($active = null, $activeDate = null, $agencyCode = null, $badgeFormatID = null, $cardID = null, $cardIdentifier = null, $cardIssueLevel = null, $cardNumber = null, $cardNumberString = null, $credentialSeriesCode = null, $customerCode = null, $encryption = null, $expiryDate = null, $extendedPIN = null, $iDSCode = null, $inactiveComment = null, $organisationAssociation = null, $organisationCategory = null, $organisationIdentifier = null, $pIN = null, $systemCode = null, $unitIDCode = null)
    {
        $this
            ->setActive($active)
            ->setActiveDate($activeDate)
            ->setAgencyCode($agencyCode)
            ->setBadgeFormatID($badgeFormatID)
            ->setCardID($cardID)
            ->setCardIdentifier($cardIdentifier)
            ->setCardIssueLevel($cardIssueLevel)
            ->setCardNumber($cardNumber)
            ->setCardNumberString($cardNumberString)
            ->setCredentialSeriesCode($credentialSeriesCode)
            ->setCustomerCode($customerCode)
            ->setEncryption($encryption)
            ->setExpiryDate($expiryDate)
            ->setExtendedPIN($extendedPIN)
            ->setIDSCode($iDSCode)
            ->setInactiveComment($inactiveComment)
            ->setOrganisationAssociation($organisationAssociation)
            ->setOrganisationCategory($organisationCategory)
            ->setOrganisationIdentifier($organisationIdentifier)
            ->setPIN($pIN)
            ->setSystemCode($systemCode)
            ->setUnitIDCode($unitIDCode);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get ActiveDate value
     * @return string|null
     */
    public function getActiveDate()
    {
        return $this->ActiveDate;
    }
    /**
     * Set ActiveDate value
     * @param string $activeDate
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setActiveDate($activeDate = null)
    {
        // validation for constraint: string
        if (!is_null($activeDate) && !is_string($activeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeDate, true), gettype($activeDate)), __LINE__);
        }
        $this->ActiveDate = $activeDate;
        return $this;
    }
    /**
     * Get AgencyCode value
     * @return int|null
     */
    public function getAgencyCode()
    {
        return $this->AgencyCode;
    }
    /**
     * Set AgencyCode value
     * @param int $agencyCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setAgencyCode($agencyCode = null)
    {
        // validation for constraint: int
        if (!is_null($agencyCode) && !(is_int($agencyCode) || ctype_digit($agencyCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyCode, true), gettype($agencyCode)), __LINE__);
        }
        $this->AgencyCode = $agencyCode;
        return $this;
    }
    /**
     * Get BadgeFormatID value
     * @return int|null
     */
    public function getBadgeFormatID()
    {
        return $this->BadgeFormatID;
    }
    /**
     * Set BadgeFormatID value
     * @param int $badgeFormatID
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setBadgeFormatID($badgeFormatID = null)
    {
        // validation for constraint: int
        if (!is_null($badgeFormatID) && !(is_int($badgeFormatID) || ctype_digit($badgeFormatID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($badgeFormatID, true), gettype($badgeFormatID)), __LINE__);
        }
        $this->BadgeFormatID = $badgeFormatID;
        return $this;
    }
    /**
     * Get CardID value
     * @return int|null
     */
    public function getCardID()
    {
        return $this->CardID;
    }
    /**
     * Set CardID value
     * @param int $cardID
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCardID($cardID = null)
    {
        // validation for constraint: int
        if (!is_null($cardID) && !(is_int($cardID) || ctype_digit($cardID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardID, true), gettype($cardID)), __LINE__);
        }
        $this->CardID = $cardID;
        return $this;
    }
    /**
     * Get CardIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardIdentifier()
    {
        return isset($this->CardIdentifier) ? $this->CardIdentifier : null;
    }
    /**
     * Set CardIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCardIdentifier($cardIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($cardIdentifier) && !is_string($cardIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIdentifier, true), gettype($cardIdentifier)), __LINE__);
        }
        if (is_null($cardIdentifier) || (is_array($cardIdentifier) && empty($cardIdentifier))) {
            unset($this->CardIdentifier);
        } else {
            $this->CardIdentifier = $cardIdentifier;
        }
        return $this;
    }
    /**
     * Get CardIssueLevel value
     * @return string|null
     */
    public function getCardIssueLevel()
    {
        return $this->CardIssueLevel;
    }
    /**
     * Set CardIssueLevel value
     * @param string $cardIssueLevel
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCardIssueLevel($cardIssueLevel = null)
    {
        // validation for constraint: string
        if (!is_null($cardIssueLevel) && !is_string($cardIssueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardIssueLevel, true), gettype($cardIssueLevel)), __LINE__);
        }
        $this->CardIssueLevel = $cardIssueLevel;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return int|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param int $cardNumber
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: int
        if (!is_null($cardNumber) && !(is_int($cardNumber) || ctype_digit($cardNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardNumberString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberString()
    {
        return isset($this->CardNumberString) ? $this->CardNumberString : null;
    }
    /**
     * Set CardNumberString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberString
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCardNumberString($cardNumberString = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberString) && !is_string($cardNumberString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberString, true), gettype($cardNumberString)), __LINE__);
        }
        if (is_null($cardNumberString) || (is_array($cardNumberString) && empty($cardNumberString))) {
            unset($this->CardNumberString);
        } else {
            $this->CardNumberString = $cardNumberString;
        }
        return $this;
    }
    /**
     * Get CredentialSeriesCode value
     * @return int|null
     */
    public function getCredentialSeriesCode()
    {
        return $this->CredentialSeriesCode;
    }
    /**
     * Set CredentialSeriesCode value
     * @param int $credentialSeriesCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCredentialSeriesCode($credentialSeriesCode = null)
    {
        // validation for constraint: int
        if (!is_null($credentialSeriesCode) && !(is_int($credentialSeriesCode) || ctype_digit($credentialSeriesCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($credentialSeriesCode, true), gettype($credentialSeriesCode)), __LINE__);
        }
        $this->CredentialSeriesCode = $credentialSeriesCode;
        return $this;
    }
    /**
     * Get CustomerCode value
     * @return int|null
     */
    public function getCustomerCode()
    {
        return $this->CustomerCode;
    }
    /**
     * Set CustomerCode value
     * @param int $customerCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: int
        if (!is_null($customerCode) && !(is_int($customerCode) || ctype_digit($customerCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->CustomerCode = $customerCode;
        return $this;
    }
    /**
     * Get Encryption value
     * @return int|null
     */
    public function getEncryption()
    {
        return $this->Encryption;
    }
    /**
     * Set Encryption value
     * @param int $encryption
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setEncryption($encryption = null)
    {
        // validation for constraint: int
        if (!is_null($encryption) && !(is_int($encryption) || ctype_digit($encryption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($encryption, true), gettype($encryption)), __LINE__);
        }
        $this->Encryption = $encryption;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get ExtendedPIN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtendedPIN()
    {
        return isset($this->ExtendedPIN) ? $this->ExtendedPIN : null;
    }
    /**
     * Set ExtendedPIN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extendedPIN
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setExtendedPIN($extendedPIN = null)
    {
        // validation for constraint: string
        if (!is_null($extendedPIN) && !is_string($extendedPIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedPIN, true), gettype($extendedPIN)), __LINE__);
        }
        if (is_null($extendedPIN) || (is_array($extendedPIN) && empty($extendedPIN))) {
            unset($this->ExtendedPIN);
        } else {
            $this->ExtendedPIN = $extendedPIN;
        }
        return $this;
    }
    /**
     * Get IDSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDSCode()
    {
        return isset($this->IDSCode) ? $this->IDSCode : null;
    }
    /**
     * Set IDSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDSCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setIDSCode($iDSCode = null)
    {
        // validation for constraint: string
        if (!is_null($iDSCode) && !is_string($iDSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSCode, true), gettype($iDSCode)), __LINE__);
        }
        if (is_null($iDSCode) || (is_array($iDSCode) && empty($iDSCode))) {
            unset($this->IDSCode);
        } else {
            $this->IDSCode = $iDSCode;
        }
        return $this;
    }
    /**
     * Get InactiveComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInactiveComment()
    {
        return isset($this->InactiveComment) ? $this->InactiveComment : null;
    }
    /**
     * Set InactiveComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inactiveComment
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setInactiveComment($inactiveComment = null)
    {
        // validation for constraint: string
        if (!is_null($inactiveComment) && !is_string($inactiveComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactiveComment, true), gettype($inactiveComment)), __LINE__);
        }
        if (is_null($inactiveComment) || (is_array($inactiveComment) && empty($inactiveComment))) {
            unset($this->InactiveComment);
        } else {
            $this->InactiveComment = $inactiveComment;
        }
        return $this;
    }
    /**
     * Get OrganisationAssociation value
     * @return int|null
     */
    public function getOrganisationAssociation()
    {
        return $this->OrganisationAssociation;
    }
    /**
     * Set OrganisationAssociation value
     * @param int $organisationAssociation
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setOrganisationAssociation($organisationAssociation = null)
    {
        // validation for constraint: int
        if (!is_null($organisationAssociation) && !(is_int($organisationAssociation) || ctype_digit($organisationAssociation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationAssociation, true), gettype($organisationAssociation)), __LINE__);
        }
        $this->OrganisationAssociation = $organisationAssociation;
        return $this;
    }
    /**
     * Get OrganisationCategory value
     * @return int|null
     */
    public function getOrganisationCategory()
    {
        return $this->OrganisationCategory;
    }
    /**
     * Set OrganisationCategory value
     * @param int $organisationCategory
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setOrganisationCategory($organisationCategory = null)
    {
        // validation for constraint: int
        if (!is_null($organisationCategory) && !(is_int($organisationCategory) || ctype_digit($organisationCategory))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationCategory, true), gettype($organisationCategory)), __LINE__);
        }
        $this->OrganisationCategory = $organisationCategory;
        return $this;
    }
    /**
     * Get OrganisationIdentifier value
     * @return int|null
     */
    public function getOrganisationIdentifier()
    {
        return $this->OrganisationIdentifier;
    }
    /**
     * Set OrganisationIdentifier value
     * @param int $organisationIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setOrganisationIdentifier($organisationIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($organisationIdentifier) && !(is_int($organisationIdentifier) || ctype_digit($organisationIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($organisationIdentifier, true), gettype($organisationIdentifier)), __LINE__);
        }
        $this->OrganisationIdentifier = $organisationIdentifier;
        return $this;
    }
    /**
     * Get PIN value
     * @return int|null
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param int $pIN
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: int
        if (!is_null($pIN) && !(is_int($pIN) || ctype_digit($pIN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pIN, true), gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get SystemCode value
     * @return int|null
     */
    public function getSystemCode()
    {
        return $this->SystemCode;
    }
    /**
     * Set SystemCode value
     * @param int $systemCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setSystemCode($systemCode = null)
    {
        // validation for constraint: int
        if (!is_null($systemCode) && !(is_int($systemCode) || ctype_digit($systemCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemCode, true), gettype($systemCode)), __LINE__);
        }
        $this->SystemCode = $systemCode;
        return $this;
    }
    /**
     * Get UnitIDCode value
     * @return int|null
     */
    public function getUnitIDCode()
    {
        return $this->UnitIDCode;
    }
    /**
     * Set UnitIDCode value
     * @param int $unitIDCode
     * @return \App\Symmetry\Entities\StructType\XML_CardInfo
     */
    public function setUnitIDCode($unitIDCode = null)
    {
        // validation for constraint: int
        if (!is_null($unitIDCode) && !(is_int($unitIDCode) || ctype_digit($unitIDCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unitIDCode, true), gettype($unitIDCode)), __LINE__);
        }
        $this->UnitIDCode = $unitIDCode;
        return $this;
    }
}
