<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_CardHolder StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_CardHolder
 * @subpackage Structs
 */
class XML_CardHolder extends AbstractStructBase
{
    /**
     * The AccessGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup
     */
    public $AccessGroups;
    /**
     * The CardHolderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CardHolderID;
    /**
     * The CardInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo
     */
    public $CardInfo;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * The EmployeeReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmployeeReference;
    /**
     * The FaceImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaceImage;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The InitLet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InitLet;
    /**
     * The IntrusionAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea
     */
    public $IntrusionAreas;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The PersonIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonIdentifier;
    /**
     * The PersonalData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData
     */
    public $PersonalData;
    /**
     * The Properties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties
     */
    public $Properties;
    /**
     * The ReaderGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup
     */
    public $ReaderGroups;
    /**
     * The Readers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader
     */
    public $Readers;
    /**
     * The SignatureImage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SignatureImage;
    /**
     * Constructor method for XML_CardHolder
     * @uses XML_CardHolder::setAccessGroups()
     * @uses XML_CardHolder::setCardHolderID()
     * @uses XML_CardHolder::setCardInfo()
     * @uses XML_CardHolder::setCompanyID()
     * @uses XML_CardHolder::setEmployeeReference()
     * @uses XML_CardHolder::setFaceImage()
     * @uses XML_CardHolder::setFirstName()
     * @uses XML_CardHolder::setInitLet()
     * @uses XML_CardHolder::setIntrusionAreas()
     * @uses XML_CardHolder::setLastName()
     * @uses XML_CardHolder::setPersonIdentifier()
     * @uses XML_CardHolder::setPersonalData()
     * @uses XML_CardHolder::setProperties()
     * @uses XML_CardHolder::setReaderGroups()
     * @uses XML_CardHolder::setReaders()
     * @uses XML_CardHolder::setSignatureImage()
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup $accessGroups
     * @param int $cardHolderID
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo $cardInfo
     * @param int $companyID
     * @param string $employeeReference
     * @param string $faceImage
     * @param string $firstName
     * @param string $initLet
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea $intrusionAreas
     * @param string $lastName
     * @param int $personIdentifier
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData $personalData
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties $properties
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers
     * @param string $signatureImage
     */
    public function __construct(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup $accessGroups = null, $cardHolderID = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo $cardInfo = null, $companyID = null, $employeeReference = null, $faceImage = null, $firstName = null, $initLet = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea $intrusionAreas = null, $lastName = null, $personIdentifier = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData $personalData = null, \App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties $properties = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups = null, \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers = null, $signatureImage = null)
    {
        $this
            ->setAccessGroups($accessGroups)
            ->setCardHolderID($cardHolderID)
            ->setCardInfo($cardInfo)
            ->setCompanyID($companyID)
            ->setEmployeeReference($employeeReference)
            ->setFaceImage($faceImage)
            ->setFirstName($firstName)
            ->setInitLet($initLet)
            ->setIntrusionAreas($intrusionAreas)
            ->setLastName($lastName)
            ->setPersonIdentifier($personIdentifier)
            ->setPersonalData($personalData)
            ->setProperties($properties)
            ->setReaderGroups($readerGroups)
            ->setReaders($readers)
            ->setSignatureImage($signatureImage);
    }
    /**
     * Get AccessGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup|null
     */
    public function getAccessGroups()
    {
        return isset($this->AccessGroups) ? $this->AccessGroups : null;
    }
    /**
     * Set AccessGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup $accessGroups
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setAccessGroups(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardAccessGroup $accessGroups = null)
    {
        if (is_null($accessGroups) || (is_array($accessGroups) && empty($accessGroups))) {
            unset($this->AccessGroups);
        } else {
            $this->AccessGroups = $accessGroups;
        }
        return $this;
    }
    /**
     * Get CardHolderID value
     * @return int|null
     */
    public function getCardHolderID()
    {
        return $this->CardHolderID;
    }
    /**
     * Set CardHolderID value
     * @param int $cardHolderID
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setCardHolderID($cardHolderID = null)
    {
        // validation for constraint: int
        if (!is_null($cardHolderID) && !(is_int($cardHolderID) || ctype_digit($cardHolderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardHolderID, true), gettype($cardHolderID)), __LINE__);
        }
        $this->CardHolderID = $cardHolderID;
        return $this;
    }
    /**
     * Get CardInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo|null
     */
    public function getCardInfo()
    {
        return isset($this->CardInfo) ? $this->CardInfo : null;
    }
    /**
     * Set CardInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo $cardInfo
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setCardInfo(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardInfo $cardInfo = null)
    {
        if (is_null($cardInfo) || (is_array($cardInfo) && empty($cardInfo))) {
            unset($this->CardInfo);
        } else {
            $this->CardInfo = $cardInfo;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EmployeeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmployeeReference()
    {
        return isset($this->EmployeeReference) ? $this->EmployeeReference : null;
    }
    /**
     * Set EmployeeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $employeeReference
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setEmployeeReference($employeeReference = null)
    {
        // validation for constraint: string
        if (!is_null($employeeReference) && !is_string($employeeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($employeeReference, true), gettype($employeeReference)), __LINE__);
        }
        if (is_null($employeeReference) || (is_array($employeeReference) && empty($employeeReference))) {
            unset($this->EmployeeReference);
        } else {
            $this->EmployeeReference = $employeeReference;
        }
        return $this;
    }
    /**
     * Get FaceImage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaceImage()
    {
        return isset($this->FaceImage) ? $this->FaceImage : null;
    }
    /**
     * Set FaceImage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faceImage
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setFaceImage($faceImage = null)
    {
        // validation for constraint: string
        if (!is_null($faceImage) && !is_string($faceImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faceImage, true), gettype($faceImage)), __LINE__);
        }
        if (is_null($faceImage) || (is_array($faceImage) && empty($faceImage))) {
            unset($this->FaceImage);
        } else {
            $this->FaceImage = $faceImage;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get InitLet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitLet()
    {
        return isset($this->InitLet) ? $this->InitLet : null;
    }
    /**
     * Set InitLet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initLet
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setInitLet($initLet = null)
    {
        // validation for constraint: string
        if (!is_null($initLet) && !is_string($initLet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initLet, true), gettype($initLet)), __LINE__);
        }
        if (is_null($initLet) || (is_array($initLet) && empty($initLet))) {
            unset($this->InitLet);
        } else {
            $this->InitLet = $initLet;
        }
        return $this;
    }
    /**
     * Get IntrusionAreas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea|null
     */
    public function getIntrusionAreas()
    {
        return isset($this->IntrusionAreas) ? $this->IntrusionAreas : null;
    }
    /**
     * Set IntrusionAreas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea $intrusionAreas
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setIntrusionAreas(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardIntrusionArea $intrusionAreas = null)
    {
        if (is_null($intrusionAreas) || (is_array($intrusionAreas) && empty($intrusionAreas))) {
            unset($this->IntrusionAreas);
        } else {
            $this->IntrusionAreas = $intrusionAreas;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get PersonIdentifier value
     * @return int|null
     */
    public function getPersonIdentifier()
    {
        return $this->PersonIdentifier;
    }
    /**
     * Set PersonIdentifier value
     * @param int $personIdentifier
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setPersonIdentifier($personIdentifier = null)
    {
        // validation for constraint: int
        if (!is_null($personIdentifier) && !(is_int($personIdentifier) || ctype_digit($personIdentifier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personIdentifier, true), gettype($personIdentifier)), __LINE__);
        }
        $this->PersonIdentifier = $personIdentifier;
        return $this;
    }
    /**
     * Get PersonalData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData|null
     */
    public function getPersonalData()
    {
        return isset($this->PersonalData) ? $this->PersonalData : null;
    }
    /**
     * Set PersonalData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData $personalData
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setPersonalData(\App\Symmetry\Entities\ArrayType\ArrayOfXML_PersonalData $personalData = null)
    {
        if (is_null($personalData) || (is_array($personalData) && empty($personalData))) {
            unset($this->PersonalData);
        } else {
            $this->PersonalData = $personalData;
        }
        return $this;
    }
    /**
     * Get Properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties|null
     */
    public function getProperties()
    {
        return isset($this->Properties) ? $this->Properties : null;
    }
    /**
     * Set Properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties $properties
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setProperties(\App\Symmetry\Entities\ArrayType\ArrayOfenCardHolderProperties $properties = null)
    {
        if (is_null($properties) || (is_array($properties) && empty($properties))) {
            unset($this->Properties);
        } else {
            $this->Properties = $properties;
        }
        return $this;
    }
    /**
     * Get ReaderGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup|null
     */
    public function getReaderGroups()
    {
        return isset($this->ReaderGroups) ? $this->ReaderGroups : null;
    }
    /**
     * Set ReaderGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setReaderGroups(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReaderGroup $readerGroups = null)
    {
        if (is_null($readerGroups) || (is_array($readerGroups) && empty($readerGroups))) {
            unset($this->ReaderGroups);
        } else {
            $this->ReaderGroups = $readerGroups;
        }
        return $this;
    }
    /**
     * Get Readers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader|null
     */
    public function getReaders()
    {
        return isset($this->Readers) ? $this->Readers : null;
    }
    /**
     * Set Readers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setReaders(\App\Symmetry\Entities\ArrayType\ArrayOfXML_CardReader $readers = null)
    {
        if (is_null($readers) || (is_array($readers) && empty($readers))) {
            unset($this->Readers);
        } else {
            $this->Readers = $readers;
        }
        return $this;
    }
    /**
     * Get SignatureImage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSignatureImage()
    {
        return isset($this->SignatureImage) ? $this->SignatureImage : null;
    }
    /**
     * Set SignatureImage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $signatureImage
     * @return \App\Symmetry\Entities\StructType\XML_CardHolder
     */
    public function setSignatureImage($signatureImage = null)
    {
        // validation for constraint: string
        if (!is_null($signatureImage) && !is_string($signatureImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($signatureImage, true), gettype($signatureImage)), __LINE__);
        }
        if (is_null($signatureImage) || (is_array($signatureImage) && empty($signatureImage))) {
            unset($this->SignatureImage);
        } else {
            $this->SignatureImage = $signatureImage;
        }
        return $this;
    }
}
