<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_BadgeFormat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_BadgeFormat
 * @subpackage Structs
 */
class XML_BadgeFormat extends AbstractStructBase
{
    /**
     * The BadgeFormatDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BadgeFormatDescription;
    /**
     * The BadgeFormatID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BadgeFormatID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CompanyID;
    /**
     * Constructor method for XML_BadgeFormat
     * @uses XML_BadgeFormat::setBadgeFormatDescription()
     * @uses XML_BadgeFormat::setBadgeFormatID()
     * @uses XML_BadgeFormat::setCompanyID()
     * @param string $badgeFormatDescription
     * @param int $badgeFormatID
     * @param int $companyID
     */
    public function __construct($badgeFormatDescription = null, $badgeFormatID = null, $companyID = null)
    {
        $this
            ->setBadgeFormatDescription($badgeFormatDescription)
            ->setBadgeFormatID($badgeFormatID)
            ->setCompanyID($companyID);
    }
    /**
     * Get BadgeFormatDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBadgeFormatDescription()
    {
        return isset($this->BadgeFormatDescription) ? $this->BadgeFormatDescription : null;
    }
    /**
     * Set BadgeFormatDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $badgeFormatDescription
     * @return \App\Symmetry\Entities\StructType\XML_BadgeFormat
     */
    public function setBadgeFormatDescription($badgeFormatDescription = null)
    {
        // validation for constraint: string
        if (!is_null($badgeFormatDescription) && !is_string($badgeFormatDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($badgeFormatDescription, true), gettype($badgeFormatDescription)), __LINE__);
        }
        if (is_null($badgeFormatDescription) || (is_array($badgeFormatDescription) && empty($badgeFormatDescription))) {
            unset($this->BadgeFormatDescription);
        } else {
            $this->BadgeFormatDescription = $badgeFormatDescription;
        }
        return $this;
    }
    /**
     * Get BadgeFormatID value
     * @return int|null
     */
    public function getBadgeFormatID()
    {
        return $this->BadgeFormatID;
    }
    /**
     * Set BadgeFormatID value
     * @param int $badgeFormatID
     * @return \App\Symmetry\Entities\StructType\XML_BadgeFormat
     */
    public function setBadgeFormatID($badgeFormatID = null)
    {
        // validation for constraint: int
        if (!is_null($badgeFormatID) && !(is_int($badgeFormatID) || ctype_digit($badgeFormatID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($badgeFormatID, true), gettype($badgeFormatID)), __LINE__);
        }
        $this->BadgeFormatID = $badgeFormatID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \App\Symmetry\Entities\StructType\XML_BadgeFormat
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !(is_int($companyID) || ctype_digit($companyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
}
