<?php

namespace App\Symmetry\Entities\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XML_AlarmStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:XML_AlarmStatus
 * @subpackage Structs
 */
class XML_AlarmStatus extends AbstractStructBase
{
    /**
     * The AlarmActionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AlarmActionStatus;
    /**
     * The AlarmID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AlarmID;
    /**
     * Constructor method for XML_AlarmStatus
     * @uses XML_AlarmStatus::setAlarmActionStatus()
     * @uses XML_AlarmStatus::setAlarmID()
     * @param string $alarmActionStatus
     * @param int $alarmID
     */
    public function __construct($alarmActionStatus = null, $alarmID = null)
    {
        $this
            ->setAlarmActionStatus($alarmActionStatus)
            ->setAlarmID($alarmID);
    }
    /**
     * Get AlarmActionStatus value
     * @return string|null
     */
    public function getAlarmActionStatus()
    {
        return $this->AlarmActionStatus;
    }
    /**
     * Set AlarmActionStatus value
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActionStatus::valueIsValid()
     * @uses \App\Symmetry\Entities\EnumType\EnAlarmActionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alarmActionStatus
     * @return \App\Symmetry\Entities\StructType\XML_AlarmStatus
     */
    public function setAlarmActionStatus($alarmActionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Symmetry\Entities\EnumType\EnAlarmActionStatus::valueIsValid($alarmActionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \App\Symmetry\Entities\EnumType\EnAlarmActionStatus', is_array($alarmActionStatus) ? implode(', ', $alarmActionStatus) : var_export($alarmActionStatus, true), implode(', ', \App\Symmetry\Entities\EnumType\EnAlarmActionStatus::getValidValues())), __LINE__);
        }
        $this->AlarmActionStatus = $alarmActionStatus;
        return $this;
    }
    /**
     * Get AlarmID value
     * @return int|null
     */
    public function getAlarmID()
    {
        return $this->AlarmID;
    }
    /**
     * Set AlarmID value
     * @param int $alarmID
     * @return \App\Symmetry\Entities\StructType\XML_AlarmStatus
     */
    public function setAlarmID($alarmID = null)
    {
        // validation for constraint: int
        if (!is_null($alarmID) && !(is_int($alarmID) || ctype_digit($alarmID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alarmID, true), gettype($alarmID)), __LINE__);
        }
        $this->AlarmID = $alarmID;
        return $this;
    }
}
